/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import cn.maarlakes.common.function.Consumer3;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StreamUtils {
    private static final int BUFFER_SIZE = 8192;

    private StreamUtils() {
    }

    @Nonnull
    public static String readAllText(@Nonnull InputStream stream) throws IOException {
        return StreamUtils.readAllText(stream, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static String readAllText(@Nonnull InputStream stream, @Nonnull Charset charset) throws IOException {
        int charsRead;
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(stream, charset);
        char[] buffer = new char[8192];
        while ((charsRead = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, charsRead);
        }
        return builder.toString();
    }

    public static int writeTo(@Nonnull InputStream in, @Nonnull OutputStream out) throws IOException {
        int result = StreamUtils.writeTo(in, out::write);
        out.flush();
        return result;
    }

    public static int writeTo(@Nonnull InputStream in, @Nonnull Consumer3<byte[], Integer, Integer> consumer) throws IOException {
        int bytesRead;
        int byteCount = 0;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) >= 0) {
            consumer.acceptUnchecked(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        return byteCount;
    }

    @Nonnull
    public static byte[] readAllBytes(@Nonnull InputStream stream) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            StreamUtils.writeTo(stream, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

