/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import jakarta.annotation.Nonnull;

public final class PathUtils {
    private PathUtils() {
    }

    @Nonnull
    public static String combine(String ... paths) {
        return PathUtils.combineWith("/", paths);
    }

    @Nonnull
    public static String combineWith(@Nonnull String delimiter, String ... paths) {
        if (paths.length < 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(paths[0]);
        int length = delimiter.length();
        for (int i = 1; i < paths.length; ++i) {
            String path = paths[i];
            if (builder.lastIndexOf(delimiter) == builder.length() - length) {
                if (path.startsWith(delimiter)) {
                    builder.append(path.substring(length));
                    continue;
                }
                builder.append(path);
                continue;
            }
            if (!path.startsWith(delimiter)) {
                builder.append(delimiter);
            }
            builder.append(path);
        }
        return builder.toString();
    }
}

