/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import cn.maarlakes.common.utils.CollectionUtils;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.Iterator;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] toArray(@Nonnull Iterable<T> iterable) {
        Class<?> type = null;
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T item = iterator.next();
            type = item.getClass();
        }
        if (type == null) {
            throw new IllegalArgumentException("iterable is null or empty");
        }
        Class<?> clazz = type;
        return CollectionUtils.stream(iterable).toArray(length -> (Object[])Array.newInstance(clazz, length));
    }
}

