/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token;

import cn.maarlakes.common.token.CacheableTokenRepository;
import cn.maarlakes.common.token.ExpirationAppToken;
import cn.maarlakes.common.token.Tokens;
import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletionStage;

public interface RefreshableTokenRepository<T extends ExpirationAppToken<A, V>, A, V>
extends CacheableTokenRepository<T, A, V> {
    default public CompletionStage<T> getTokenAsync(@Nonnull A appId, boolean autoRefresh) {
        if (autoRefresh) {
            return Tokens.autoRefreshAsync(this, this.getTokenAsync(appId));
        }
        return this.getTokenAsync(appId);
    }

    @Nonnull
    public CompletionStage<T> refreshAsync(@Nonnull T var1);

    @Nonnull
    default public T refresh(@Nonnull T token) {
        try {
            return (T)((ExpirationAppToken)this.refreshAsync(token).toCompletableFuture().get());
        }
        catch (Exception e) {
            throw Tokens.newTokenException(e);
        }
    }
}

