/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token;

import cn.maarlakes.common.token.ExpirationAppToken;
import cn.maarlakes.common.token.ExpirationTokenRepository;
import cn.maarlakes.common.token.RedissonCacheableAppTokenRepository;
import cn.maarlakes.common.token.TokenFactory;
import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletionStage;
import org.redisson.api.RedissonClient;

public class RedissonExpirationTokenRepository<T extends ExpirationAppToken<A, V>, A, V>
extends RedissonCacheableAppTokenRepository<T, A, V>
implements ExpirationTokenRepository<T, A, V> {
    public RedissonExpirationTokenRepository(@Nonnull RedissonClient client, @Nonnull String namespace, @Nonnull TokenFactory<T, A, V> tokenFactory) {
        super(client, namespace, tokenFactory);
    }

    @Override
    @Nonnull
    public CompletionStage<Void> removeExpiredTokenAsync() {
        return this.mapCache.clearExpireAsync().thenRun(() -> {});
    }

    @Override
    @Nonnull
    public CompletionStage<T> refreshAsync(@Nonnull T token) {
        return this.mapCache.removeAsync(token.getAppId(), token).toCompletableFuture().thenCompose(r -> this.getTokenAsync(token.getAppId()));
    }
}

