/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.task;

import cn.maarlakes.common.task.TaskContext;
import cn.maarlakes.common.task.TaskExecutor;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public final class TaskExecutors {
    private TaskExecutors() {
    }

    public static <T> void execute(@Nonnull List<? extends TaskExecutor<T>> executors, @Nonnull TaskContext<T> context) {
        executors.forEach(executor -> executor.execute(context));
    }

    public static <T> CompletionStage<Void> executeAsync(@Nonnull List<? extends TaskExecutor<T>> taskExecutors, @Nonnull TaskContext<T> context) {
        return TaskExecutors.executeAsync(taskExecutors, context, ForkJoinPool.commonPool());
    }

    public static <T> CompletionStage<Void> executeAsync(@Nonnull List<? extends TaskExecutor<T>> taskExecutors, @Nonnull TaskContext<T> context, @Nonnull Executor executor) {
        return CompletableFuture.runAsync(() -> TaskExecutors.execute(taskExecutors, context), executor);
    }
}

