/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.task;

import cn.maarlakes.common.factory.bean.BeanFactories;
import cn.maarlakes.common.locks.LockClient;
import cn.maarlakes.common.locks.LockContext;
import cn.maarlakes.common.task.IgnoredSerialTaskExecuteStrategy;
import cn.maarlakes.common.task.SerialTask;
import cn.maarlakes.common.task.SerialTaskExecuteStrategy;
import cn.maarlakes.common.utils.PointcutUtils;
import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;

public class SerialTaskMethodInterceptor
implements MethodInterceptor,
PointcutAdvisor,
AopInfrastructureBean {
    private static final Logger log = LoggerFactory.getLogger(SerialTaskMethodInterceptor.class);
    private final Pointcut pointcut;
    private final LockClient lockClient;

    public SerialTaskMethodInterceptor(@Nonnull LockClient lockClient) {
        this.lockClient = Objects.requireNonNull(lockClient);
        this.pointcut = PointcutUtils.forAnnotations(SerialTask.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        SerialTask serialTask = (SerialTask)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)invocation.getMethod(), SerialTask.class);
        Assert.state((serialTask != null ? 1 : 0) != 0, (String)"SerialTask is null.");
        String taskName = SerialTaskMethodInterceptor.getTaskName(serialTask, invocation.getMethod());
        Lock lock = this.lockClient.createLock(LockContext.create(taskName, serialTask.fair()));
        if (serialTask.timeout() > 0) {
            if (!lock.tryLock(serialTask.timeout(), TimeUnit.MILLISECONDS)) {
                return SerialTaskMethodInterceptor.getSerialTaskExecuteStrategy(serialTask.strategy()).execute(taskName, invocation, lock);
            }
        } else {
            lock.lock();
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    @Nonnull
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Nonnull
    public Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return true;
    }

    private static SerialTaskExecuteStrategy getSerialTaskExecuteStrategy(Class<? extends SerialTaskExecuteStrategy> type) {
        if (type == IgnoredSerialTaskExecuteStrategy.class) {
            return IgnoredSerialTaskExecuteStrategy.getInstance();
        }
        return BeanFactories.getBean(SerialTaskExecuteStrategy.class);
    }

    private static String getTaskName(@Nonnull SerialTask serialTask, @Nonnull Method method) {
        String value = serialTask.value();
        if (value == null || value.isEmpty()) {
            return method.getDeclaringClass().getName() + "." + method.getName();
        }
        return value;
    }
}

