/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.task;

import cn.maarlakes.common.AnnotationOrderComparator;
import cn.maarlakes.common.task.ScheduledTaskService;
import cn.maarlakes.common.task.TaskContext;
import cn.maarlakes.common.task.TaskExecutor;
import cn.maarlakes.common.task.TaskExecutors;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public abstract class AbstractScheduledTaskService<T>
implements ScheduledTaskService<T> {
    protected final List<? extends TaskExecutor<T>> taskExecutors;
    protected final Executor executor;

    protected AbstractScheduledTaskService(@Nonnull List<? extends TaskExecutor<T>> taskExecutors, @Nonnull Executor executor) {
        this.executor = executor;
        this.taskExecutors = taskExecutors.stream().sorted(AnnotationOrderComparator.getInstance()).collect(Collectors.toList());
    }

    protected void executeTask(T task) {
        Logger log = this.log();
        if (log.isDebugEnabled()) {
            log.debug("\u4efb\u52a1\u8c03\u5ea6\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{}\uff0c\u4efb\u52a1\u5185\u5bb9\uff1a{}", (Object)this.getTaskName(), task);
        }
        TaskExecutors.executeAsync(this.taskExecutors, new DefaultTaskContext(task), this.executor).whenComplete((r, error) -> {
            if (error != null && log.isErrorEnabled()) {
                log.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{}\uff0c\u4efb\u52a1\u5185\u5bb9\uff1a{}", (Object)this.getTaskName(), task);
            }
        });
    }

    @Nonnull
    protected abstract Logger log();

    protected class DefaultTaskContext
    implements TaskContext<T> {
        private final T task;

        public DefaultTaskContext(T task) {
            this.task = task;
        }

        @Override
        @Nonnull
        public ScheduledTaskService<T> getService() {
            return AbstractScheduledTaskService.this;
        }

        @Override
        public T getTask() {
            return this.task;
        }
    }
}

