/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.spi;

import cn.maarlakes.common.AnnotationOrderComparator;
import cn.maarlakes.common.spi.SpiService;
import cn.maarlakes.common.spi.SpiServiceException;
import cn.maarlakes.common.utils.Lazy;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class SpiServiceLoader<T>
implements Iterable<T> {
    private static final String PREFIX = "META-INF/services/";
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<Class<?>, SpiServiceLoader<?>>> SERVICE_LOADER_CACHE = new ConcurrentHashMap();
    private final Class<T> service;
    private final ClassLoader loader;
    private final boolean isShared;
    private final Supplier<Collection<Holder>> holders = Lazy.of(this::loadServiceHolder);
    private final ConcurrentMap<Class<?>, T> serviceCache = new ConcurrentHashMap();

    private SpiServiceLoader(@Nonnull Class<T> service, ClassLoader loader, boolean isShared) {
        this.service = Objects.requireNonNull(service, "Service interface cannot be null");
        this.loader = loader == null ? service.getClassLoader() : loader;
        this.isShared = isShared;
    }

    public boolean isEmpty() {
        return this.holders.get().isEmpty();
    }

    @Nonnull
    public T first() {
        return this.firstOptional().orElseThrow(() -> new SpiServiceException("No service provider found for " + this.service.getName()));
    }

    @Nonnull
    public T first(@Nonnull Class<? extends T> serviceType) {
        return this.firstOptional(serviceType).orElseThrow(() -> new SpiServiceException("No service provider found for " + serviceType.getName()));
    }

    @Nonnull
    public Optional<T> firstOptional() {
        return this.firstOptional(this.service);
    }

    @Nonnull
    public Optional<T> firstOptional(@Nonnull Class<? extends T> serviceType) {
        return this.stream(serviceType).findFirst();
    }

    @Nonnull
    public T last() {
        return this.lastOptional().orElseThrow(() -> new SpiServiceException("No service provider found for " + this.service.getName()));
    }

    @Nonnull
    public Optional<T> lastOptional() {
        return this.lastOptional(this.service);
    }

    @Nonnull
    public T last(@Nonnull Class<? extends T> serviceType) {
        return this.lastOptional(serviceType).orElseThrow(() -> new SpiServiceException("No service provider found for " + serviceType.getName()));
    }

    @Nonnull
    public Optional<T> lastOptional(@Nonnull Class<? extends T> serviceType) {
        return this.stream(serviceType, AnnotationOrderComparator.getInstance().reversed()).findFirst();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Nonnull
    public Stream<T> stream() {
        return this.stream(this.service);
    }

    public <S extends T> Stream<S> stream(@Nonnull Class<S> serviceTye) {
        return this.stream(serviceTye, AnnotationOrderComparator.getInstance());
    }

    @Nonnull
    public static <S> SpiServiceLoader<S> load(@Nonnull Class<S> service) {
        return SpiServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    @Nonnull
    public static <S> SpiServiceLoader<S> load(@Nonnull Class<S> service, ClassLoader loader) {
        return new SpiServiceLoader<S>(service, loader, false);
    }

    public static <S> SpiServiceLoader<S> loadShared(@Nonnull Class<S> service) {
        return SpiServiceLoader.loadShared(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> SpiServiceLoader<S> loadShared(@Nonnull Class<S> service, ClassLoader loader) {
        ClassLoader cl = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        return SERVICE_LOADER_CACHE.computeIfAbsent(cl, k -> new ConcurrentHashMap()).computeIfAbsent(service, k -> new SpiServiceLoader(service, cl, true));
    }

    private <S extends T> Stream<? extends S> stream(@Nonnull Class<? extends S> serviceType, @Nonnull Comparator<? super S> comparator) {
        return this.holders.get().stream().filter(item -> serviceType.isAssignableFrom(((Holder)item).serviceType)).map(this::loadService).map(serviceType::cast).sorted(comparator);
    }

    private T loadService(@Nonnull Holder holder) {
        if (holder.spiService != null && holder.spiService.lifecycle() == SpiService.Lifecycle.SINGLETON) {
            return (T)this.serviceCache.computeIfAbsent(holder.serviceType, k -> this.createService(holder));
        }
        return this.createService(holder);
    }

    private T createService(@Nonnull Holder holder) {
        try {
            return this.service.cast(holder.serviceType.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new SpiServiceException(e.getMessage(), e);
        }
    }

    private Collection<Holder> loadServiceHolder() {
        Enumeration<URL> configs = this.loadConfigs();
        try {
            HashMap<String, Holder> map = new HashMap<String, Holder>();
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        String ln;
                        int lineNumber = 0;
                        while ((ln = reader.readLine()) != null) {
                            ++lineNumber;
                            int ci = ln.indexOf(35);
                            if (ci >= 0) {
                                ln = ln.substring(0, ci);
                            }
                            if ((ln = ln.trim()).isEmpty()) continue;
                            this.check(url, ln, lineNumber);
                            if (map.containsKey(ln)) continue;
                            Class<?> type = Class.forName(ln, false, this.loader);
                            if (!this.service.isAssignableFrom(type)) {
                                throw new SpiServiceException(this.service.getName() + ": Provider" + ln + " not a subtype");
                            }
                            map.put(ln, new Holder(type, type.getAnnotation(SpiService.class)));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            if (map.isEmpty() && this.isShared) {
                this.remove();
            }
            return map.values();
        }
        catch (IOException | ClassNotFoundException e) {
            if (this.isShared) {
                this.remove();
            }
            throw new SpiServiceException(e);
        }
    }

    private void remove() {
        ConcurrentMap map = (ConcurrentMap)SERVICE_LOADER_CACHE.get(this.loader);
        if (map != null) {
            map.remove(this.service);
        }
    }

    private Enumeration<URL> loadConfigs() {
        String fullName = PREFIX + this.service.getName();
        try {
            return this.loader.getResources(fullName);
        }
        catch (IOException e) {
            throw new SpiServiceException(this.service.getName() + ": Error locating configuration files", e);
        }
    }

    private void check(@Nonnull URL url, @Nonnull String className, int lineNumber) {
        if (className.indexOf(32) >= 0 || className.indexOf(9) >= 0) {
            throw new SpiServiceException(this.service.getName() + ": " + className + ":" + lineNumber + ":Illegal configuration-file syntax");
        }
        int cp = className.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            throw new SpiServiceException(this.service.getName() + ": " + url + ":" + lineNumber + ":Illegal provider-class name: " + className);
        }
        int length = className.length();
        for (int i = Character.charCount(cp); i < length; i += Character.charCount(cp)) {
            cp = className.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
            throw new SpiServiceException(this.service.getName() + ": " + url + ":" + lineNumber + ":Illegal provider-class name: " + className);
        }
    }

    private static final class Holder {
        private final Class<?> serviceType;
        private final SpiService spiService;

        private Holder(@Nonnull Class<?> serviceType, SpiService spiService) {
            this.serviceType = serviceType;
            this.spiService = spiService;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Holder) {
                return this.serviceType == ((Holder)obj).serviceType;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.serviceType);
        }
    }
}

