/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.queue.redis;

import cn.maarlakes.common.queue.DelayedQueue;
import cn.maarlakes.common.queue.QueueClient;
import cn.maarlakes.common.queue.TopicQueue;
import cn.maarlakes.common.queue.redis.RedissonDelayQueue;
import cn.maarlakes.common.queue.redis.RedissonTopicQueue;
import cn.maarlakes.common.utils.ExecutorFactory;
import cn.maarlakes.common.utils.SharedExecutorFactory;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.Kryo5Codec;

public class RedissonQueueClient
implements QueueClient {
    private final Codec codec;
    private final RedissonClient redissonClient;
    private final String namespace;
    private final ExecutorFactory executorFactory;
    private final Map<String, Executor> executors = new ConcurrentHashMap<String, Executor>();

    public RedissonQueueClient(@Nonnull RedissonClient redissonClient, @Nonnull String namespace) {
        this(redissonClient, (Codec)new Kryo5Codec(), namespace);
    }

    public RedissonQueueClient(@Nonnull RedissonClient redissonClient, @Nonnull Codec codec, @Nonnull String namespace) {
        this(redissonClient, codec, namespace, new SharedExecutorFactory(new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 2, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>())));
    }

    public RedissonQueueClient(@Nonnull RedissonClient redissonClient, @Nonnull String namespace, @Nonnull ExecutorFactory executorFactory) {
        this(redissonClient, (Codec)new Kryo5Codec(), namespace, executorFactory);
    }

    public RedissonQueueClient(@Nonnull RedissonClient redissonClient, @Nonnull Codec codec, @Nonnull String namespace, @Nonnull ExecutorFactory executorFactory) {
        this.redissonClient = redissonClient;
        this.codec = codec;
        this.namespace = namespace;
        this.executorFactory = executorFactory;
    }

    @Override
    @Nonnull
    public <T> TopicQueue<T> getQueue(@Nonnull String name) {
        Executor executor = this.executors.computeIfAbsent(name, k -> this.executorFactory.createExecutor());
        return new RedissonTopicQueue(name, this.redissonClient.getBlockingQueue(this.getName(name), this.codec), executor);
    }

    @Override
    @Nonnull
    public <T> DelayedQueue<T> getDelayedQueue(@Nonnull String name) {
        Executor executor = this.executors.computeIfAbsent(name, k -> this.executorFactory.createExecutor());
        RBlockingQueue queue = this.redissonClient.getBlockingQueue(this.getName(name), this.codec);
        return new RedissonDelayQueue(name, queue, this.redissonClient.getDelayedQueue((RQueue)queue), executor);
    }

    private String getName(@Nonnull String name) {
        if (this.namespace.endsWith(":")) {
            return this.namespace + name;
        }
        return this.namespace + ":" + name;
    }
}

