/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.queue;

import cn.maarlakes.common.function.Function1;
import cn.maarlakes.common.queue.DelayedQueue;
import cn.maarlakes.common.queue.MemoryDelayQueue;
import cn.maarlakes.common.queue.MemoryTopicQueue;
import cn.maarlakes.common.queue.QueueClient;
import cn.maarlakes.common.queue.TopicQueue;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public class MemoryQueueClient
implements QueueClient {
    private final Function1<String, Executor> executorFactory;
    private final Map<String, TopicQueue<?>> topicQueue = new ConcurrentHashMap();
    private final Map<String, DelayedQueue<?>> delayedQueue = new ConcurrentHashMap();

    public MemoryQueueClient() {
        this(value -> new ForkJoinPool());
    }

    public MemoryQueueClient(@Nonnull Function1<String, Executor> executorFactory) {
        this.executorFactory = executorFactory;
    }

    @Override
    @Nonnull
    public <T> TopicQueue<T> getQueue(@Nonnull String name) {
        return this.topicQueue.computeIfAbsent(name, k -> new MemoryTopicQueue(name, this.executorFactory.apply(name)));
    }

    @Override
    @Nonnull
    public <T> DelayedQueue<T> getDelayedQueue(@Nonnull String name) {
        return this.delayedQueue.computeIfAbsent(name, k -> new MemoryDelayQueue(name, this.executorFactory.apply(name)));
    }
}

