/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.locks;

import cn.maarlakes.common.locks.ExpressionLockContextFactory;
import cn.maarlakes.common.locks.LockClient;
import cn.maarlakes.common.locks.LockContextFactory;
import cn.maarlakes.common.locks.SyncLock;
import cn.maarlakes.common.locks.SyncLockTimeoutException;
import cn.maarlakes.common.utils.PointcutUtils;
import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;

public class SyncLockMethodInterceptor
implements MethodInterceptor,
PointcutAdvisor,
AopInfrastructureBean {
    private final Pointcut pointcut;
    private final LockClient lockClient;
    private final LockContextFactory lockContextFactory;

    public SyncLockMethodInterceptor(@Nonnull LockClient lockClient) {
        this(lockClient, new ExpressionLockContextFactory());
    }

    public SyncLockMethodInterceptor(@Nonnull LockClient lockClient, @Nonnull LockContextFactory lockContextFactory) {
        this.lockClient = Objects.requireNonNull(lockClient);
        this.lockContextFactory = Objects.requireNonNull(lockContextFactory);
        this.pointcut = PointcutUtils.forAnnotations(SyncLock.class);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        SyncLock syncLock = (SyncLock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)invocation.getMethod(), SyncLock.class);
        Assert.state((syncLock != null ? 1 : 0) != 0, (String)"SyncLock is null.");
        String value = syncLock.value();
        if (value == null || value.isEmpty()) {
            value = "'" + invocation.getMethod() + "'";
        }
        Lock lock = this.lockClient.createLock(this.lockContextFactory.create(value, invocation));
        if (syncLock.timeout() > 0L) {
            if (!lock.tryLock(syncLock.timeout(), TimeUnit.MILLISECONDS)) {
                throw new SyncLockTimeoutException("method: " + invocation.getMethod());
            }
        } else {
            lock.lock();
        }
        return SyncLockMethodInterceptor.invokeUnlock(syncLock, invocation.proceed(), lock);
    }

    @Nonnull
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Nonnull
    public Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invokeUnlock(@Nonnull SyncLock syncLock, @Nonnull Object result, @Nonnull Lock lock) {
        if (syncLock.supportAsync()) {
            if (result instanceof CompletionStage) {
                return ((CompletionStage)result).whenComplete((v, r) -> lock.unlock());
            }
            if (result instanceof Callable) {
                return () -> {
                    try {
                        Object v = ((Callable)result).call();
                        return v;
                    }
                    finally {
                        lock.unlock();
                    }
                };
            }
            if (result instanceof Runnable) {
                return () -> {
                    try {
                        ((Runnable)result).run();
                    }
                    finally {
                        lock.unlock();
                    }
                };
            }
            if (result instanceof Supplier) {
                return () -> {
                    try {
                        Object t = ((Supplier)result).get();
                        return t;
                    }
                    finally {
                        lock.unlock();
                    }
                };
            }
        }
        try {
            Object object = result;
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

