/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.locks;

import cn.maarlakes.common.factory.bean.BeanFactories;
import cn.maarlakes.common.locks.ExpressionLockContext;
import cn.maarlakes.common.locks.LockContext;
import cn.maarlakes.common.locks.LockContextFactory;
import cn.maarlakes.common.locks.SyncLock;
import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionLockContextFactory
implements LockContextFactory {
    private final ParameterNameDiscoverer parameterNameDiscoverer = new StandardReflectionParameterNameDiscoverer();

    @Override
    public LockContext create(@Nonnull String key, @Nonnull MethodInvocation invocation) {
        StandardEvaluationContext context = new StandardEvaluationContext(invocation.getThis());
        String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(invocation.getMethod());
        if (parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                context.setVariable(parameterNames[i], invocation.getArguments()[i]);
            }
        }
        context.setBeanResolver((c, beanName) -> BeanFactories.getBean(beanName));
        SyncLock syncLock = (SyncLock)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)invocation.getMethod(), SyncLock.class);
        return ExpressionLockContext.create((EvaluationContext)context, key, syncLock != null && syncLock.fair());
    }
}

