/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.locks;

import cn.maarlakes.common.locks.DefaultExpressionLockContext;
import cn.maarlakes.common.locks.LockContext;
import jakarta.annotation.Nonnull;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public interface ExpressionLockContext
extends LockContext {
    @Nonnull
    public EvaluationContext evaluationContext();

    @Nonnull
    public ExpressionParser expressionParser();

    @Nonnull
    public String expression();

    @Override
    @Nonnull
    default public String key() {
        try {
            Object value;
            Object root = this.evaluationContext().getRootObject().getValue();
            if (root == null) {
                root = this;
            }
            if ((value = this.expressionParser().parseExpression(this.expression()).getValue(this.evaluationContext(), root)) == null) {
                return this.expression();
            }
            return value.toString();
        }
        catch (Exception ignored) {
            return this.expression();
        }
    }

    @Nonnull
    public static ExpressionLockContext create(@Nonnull EvaluationContext context, @Nonnull String expression) {
        return new DefaultExpressionLockContext((ExpressionParser)new SpelExpressionParser(), context, expression, false);
    }

    @Nonnull
    public static ExpressionLockContext create(@Nonnull EvaluationContext context, @Nonnull String expression, boolean fair) {
        return new DefaultExpressionLockContext((ExpressionParser)new SpelExpressionParser(), context, expression, fair);
    }

    @Nonnull
    public static ExpressionLockContext create(@Nonnull ExpressionParser parser, @Nonnull EvaluationContext context, @Nonnull String expression) {
        return new DefaultExpressionLockContext(parser, context, expression, false);
    }

    @Nonnull
    public static ExpressionLockContext create(@Nonnull ExpressionParser parser, @Nonnull EvaluationContext context, @Nonnull String expression, boolean fair) {
        return new DefaultExpressionLockContext(parser, context, expression, fair);
    }
}

