/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.locks;

import cn.maarlakes.common.locks.ExpressionLockContext;
import jakarta.annotation.Nonnull;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;

class DefaultExpressionLockContext
implements ExpressionLockContext {
    private final ExpressionParser parser;
    private final EvaluationContext context;
    private final String expression;
    private final boolean fair;

    public DefaultExpressionLockContext(@Nonnull ExpressionParser parser, @Nonnull EvaluationContext context, @Nonnull String expression, boolean fair) {
        this.parser = parser;
        this.context = context;
        this.expression = expression;
        this.fair = fair;
    }

    @Override
    @Nonnull
    public EvaluationContext evaluationContext() {
        return this.context;
    }

    @Override
    @Nonnull
    public ExpressionParser expressionParser() {
        return this.parser;
    }

    @Override
    @Nonnull
    public String expression() {
        return this.expression;
    }

    @Override
    public boolean isFair() {
        return this.fair;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExpressionLockContext) {
            ExpressionLockContext that = (ExpressionLockContext)o;
            return this.fair == that.isFair() && this.parser.equals(that.expressionParser()) && this.context.equals(that.evaluationContext()) && this.expression.equals(that.expression());
        }
        return false;
    }

    public int hashCode() {
        int result = this.parser.hashCode();
        result = 31 * result + this.context.hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + Boolean.hashCode(this.fair);
        return result;
    }

    public String toString() {
        return "expression='" + this.expression + '\'' + ", fair=" + this.fair;
    }
}

