/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.id;

import cn.maarlakes.common.id.IdGenerator;
import jakarta.annotation.Nonnull;
import java.security.SecureRandom;
import java.util.Random;

public final class TimestampIdGenerator
implements IdGenerator {
    private final Random random = new SecureRandom();
    private volatile long lastTimestamp;
    private long lastValue;
    private final long maxValue;
    private final int valueLength;
    private final int byteSize;

    public TimestampIdGenerator(int randomSize) {
        this.valueLength = randomSize;
        if (randomSize <= 0) {
            throw new IllegalArgumentException("randomSize must be greater than 0");
        }
        long value = 0L;
        for (int i = 0; i < randomSize; ++i) {
            value = value * 10L + 9L;
        }
        this.maxValue = value;
        int bitCount = Long.bitCount(this.maxValue);
        int byteSize = bitCount / 8;
        if (bitCount % 8 != 0) {
            ++byteSize;
        }
        this.byteSize = byteSize + 1;
    }

    @Override
    @Nonnull
    public synchronized String generateId() {
        String value;
        long now = System.currentTimeMillis();
        if (now == this.lastTimestamp) {
            ++this.lastValue;
            if (this.lastValue > this.maxValue) {
                while (now == this.lastTimestamp) {
                    now = System.currentTimeMillis();
                }
                this.lastTimestamp = now;
                this.generateLastValue();
            }
        } else {
            this.lastTimestamp = now;
            this.generateLastValue();
        }
        if ((value = Long.toString(this.lastValue)).length() >= this.valueLength) {
            return this.lastTimestamp + value;
        }
        StringBuilder str = new StringBuilder(value);
        while (str.length() < this.valueLength) {
            str.insert(0, "0");
        }
        return this.lastTimestamp + str.toString();
    }

    private void generateLastValue() {
        byte[] buffer = new byte[this.byteSize];
        this.random.nextBytes(buffer);
        long value = 0L;
        for (byte b : buffer) {
            value = value << 8 | (long)(b & 0xFF);
        }
        this.lastValue = value & this.maxValue;
    }
}

