/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.id;

import cn.maarlakes.common.id.IdGenerator;
import jakarta.annotation.Nonnull;
import java.util.UUID;

public final class ShortUuidGenerator
implements IdGenerator {
    public static final char[] DEFAULT_ALPHABET = "0123456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ".toCharArray();
    private final char[] alphabet;

    public ShortUuidGenerator() {
        this(DEFAULT_ALPHABET);
    }

    public ShortUuidGenerator(@Nonnull char[] alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    @Nonnull
    public String generateId() {
        UUID uuid = UUID.randomUUID();
        StringBuilder builder = new StringBuilder();
        ShortUuidGenerator.toString(builder, this.alphabet, uuid.getMostSignificantBits());
        ShortUuidGenerator.toString(builder, this.alphabet, uuid.getLeastSignificantBits());
        return builder.toString();
    }

    private static void toString(StringBuilder builder, char[] alphabet, long value) {
        for (value = Math.abs(value); value > 0L; value /= (long)alphabet.length) {
            builder.append(alphabet[(int)(value % (long)alphabet.length)]);
        }
    }
}

