/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.ok;

import cn.maarlakes.common.function.Function0;
import cn.maarlakes.common.http.ByteArrayResponseBody;
import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.ContentTypes;
import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.HttpClientException;
import cn.maarlakes.common.http.HttpHeaders;
import cn.maarlakes.common.http.NameValuePair;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.http.RequestBody;
import cn.maarlakes.common.http.Response;
import cn.maarlakes.common.http.ResponseBody;
import cn.maarlakes.common.http.body.multipart.MultipartBody;
import cn.maarlakes.common.http.body.multipart.MultipartPart;
import cn.maarlakes.common.http.ok.ContentRequestBody;
import cn.maarlakes.common.utils.CollectionUtils;
import cn.maarlakes.common.utils.Lazy;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Route;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealConnection;

public class OkAsyncHttpClient
implements HttpClient {
    private final OkHttpClient client;

    public OkAsyncHttpClient() {
        this(new OkHttpClient.Builder().build());
    }

    public OkAsyncHttpClient(@Nonnull OkHttpClient client) {
        this.client = client;
    }

    @Override
    @Nonnull
    public CompletionStage<? extends Response> execute(@Nonnull Request request) {
        try {
            HttpUrl.Builder builder = Objects.requireNonNull(HttpUrl.get((URI)request.getUri())).newBuilder();
            if (CollectionUtils.isNotEmpty(request.getQueryParams())) {
                for (NameValuePair nameValuePair : request.getQueryParams()) {
                    builder.addQueryParameter(nameValuePair.getName(), nameValuePair.getValue());
                }
            }
            Request.Builder requestBuilder = new Request.Builder().method(request.getMethod().name(), OkAsyncHttpClient.toRequestBody(request)).url(builder.build());
            if (!request.getHeaders().isEmpty()) {
                for (Header header : request.getHeaders()) {
                    for (String value : header.getValues()) {
                        requestBuilder.addHeader(header.getName(), value);
                    }
                }
            }
            final ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
            OkHttpClient client = this.getClient(request, arrayList);
            final CompletableFuture future = new CompletableFuture();
            client.newCall(requestBuilder.build()).enqueue(new Callback(){

                public void onFailure(@Nonnull Call call, @Nonnull IOException e) {
                    future.completeExceptionally(new HttpClientException(e.getMessage(), e));
                }

                public void onResponse(@Nonnull Call call, @Nonnull okhttp3.Response response) throws IOException {
                    future.complete(new DefaultResponse(response, arrayList));
                }
            });
            return future;
        }
        catch (Exception e) {
            return CompletableFuture.supplyAsync(() -> {
                throw new HttpClientException(e.getMessage(), e);
            });
        }
    }

    private OkHttpClient getClient(@Nonnull Request request, final List<Cookie> responseCookies) {
        final List<? extends Cookie> cookies = request.getCookies();
        return this.client.newBuilder().cookieJar(new CookieJar(){

            public void saveFromResponse(@Nonnull HttpUrl httpUrl, @Nonnull List<okhttp3.Cookie> list) {
                if (CollectionUtils.isNotEmpty(list)) {
                    for (okhttp3.Cookie cookie : list) {
                        Cookie.Builder builder = Cookie.builder(cookie.name()).value(cookie.value()).domain(cookie.domain()).path(cookie.path());
                        if (cookie.expiresAt() > 0L) {
                            builder.maxAge((System.currentTimeMillis() - cookie.expiresAt()) / 1000L);
                        }
                        builder.isSecure(cookie.secure());
                        builder.isHttpOnly(cookie.hostOnly());
                        responseCookies.add(builder.build());
                    }
                }
            }

            @Nonnull
            public List<okhttp3.Cookie> loadForRequest(@Nonnull HttpUrl httpUrl) {
                ArrayList<okhttp3.Cookie> list = new ArrayList<okhttp3.Cookie>();
                for (Cookie cookie : cookies) {
                    Cookie.Builder cookieBuilder = new Cookie.Builder().name(cookie.name()).value(cookie.value());
                    if (cookie.domain() != null) {
                        cookieBuilder.domain(cookie.domain());
                    } else {
                        cookieBuilder.domain(httpUrl.host());
                    }
                    if (cookie.path() != null) {
                        cookieBuilder.path(cookie.path());
                    }
                    if (cookie.maxAge() > 0L) {
                        cookieBuilder.expiresAt(System.currentTimeMillis() + cookie.maxAge() * 1000L);
                    }
                    if (cookie.isSecure()) {
                        cookieBuilder.secure();
                    }
                    if (cookie.isHttpOnly()) {
                        cookieBuilder.httpOnly();
                    }
                    list.add(cookieBuilder.build());
                }
                return list;
            }
        }).build();
    }

    private static okhttp3.RequestBody toRequestBody(@Nonnull Request request) throws Exception {
        RequestBody<?> body = request.getBody();
        if (body != null) {
            if (body instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)request.getBody();
                if (CollectionUtils.isNotEmpty((Collection)multipartBody.getContent())) {
                    MultipartBody.Builder builder = new MultipartBody.Builder();
                    builder.setType(Objects.requireNonNull(MediaType.parse((String)ContentTypes.toString(multipartBody.getContentType()))));
                    for (MultipartPart part : (Collection)multipartBody.getContent()) {
                        Headers.Builder headers = new Headers.Builder();
                        if (!part.getHeaders().isEmpty()) {
                            for (Header header : part.getHeaders()) {
                                for (String value : header.getValues()) {
                                    headers.add(header.getName(), value);
                                }
                            }
                        }
                        builder.addFormDataPart(part.getName(), part.getFilename(), (okhttp3.RequestBody)new ContentRequestBody(part));
                    }
                    return builder.build();
                }
            } else {
                return new ContentRequestBody(body);
            }
        }
        if (CollectionUtils.isNotEmpty(request.getFormParams())) {
            FormBody.Builder builder = new FormBody.Builder();
            for (NameValuePair nameValuePair : request.getFormParams()) {
                builder.add(nameValuePair.getName(), nameValuePair.getValue());
            }
            return builder.build();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    private static class DefaultResponse
    implements Response {
        private final okhttp3.Response response;
        private final List<Cookie> cookies;
        private final Function0<ResponseBody> bodyFactory;

        private DefaultResponse(@Nonnull okhttp3.Response response, List<Cookie> cookies) {
            this.response = response;
            this.cookies = cookies;
            this.bodyFactory = Lazy.of(() -> {
                okhttp3.ResponseBody body = response.body();
                if (body == null) {
                    return new ByteArrayResponseBody(new byte[0], null);
                }
                return new ByteArrayResponseBody(body.bytes(), Optional.ofNullable(body.contentType()).map(MediaType::toString).map(ContentType::parse).orElse(null));
            });
        }

        @Override
        public int getStatusCode() {
            return this.response.code();
        }

        @Override
        public String getStatusText() {
            return this.response.message();
        }

        @Override
        @Nonnull
        public ResponseBody getBody() {
            return this.bodyFactory.get();
        }

        @Override
        public URI getUri() {
            return this.response.request().url().uri();
        }

        @Override
        @Nonnull
        public HttpHeaders getHeaders() {
            final Set names = this.response.headers().names();
            return new HttpHeaders(){

                @Override
                public boolean isEmpty() {
                    return names.isEmpty();
                }

                @Override
                public Header getHeader(@Nonnull String name) {
                    return new DefaultHeader(name, response.headers(name));
                }

                @Override
                @Nonnull
                public Iterator<Header> iterator() {
                    final Iterator iterator = names.iterator();
                    return new Iterator<Header>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public Header next() {
                            return this.getHeader((String)iterator.next());
                        }
                    };
                }

                public String toString() {
                    return response.headers().toString();
                }
            };
        }

        @Override
        @Nonnull
        public List<? extends Cookie> getCookies() {
            return new ArrayList<Cookie>(this.cookies);
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return Optional.ofNullable(this.response.exchange()).map(Exchange::getConnection$okhttp).map(RealConnection::route).map(Route::socketAddress).orElse(null);
        }
    }
}

