/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.body.multipart;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.RequestBody;
import cn.maarlakes.common.http.body.multipart.ByteArrayPart;
import cn.maarlakes.common.http.body.multipart.DefaultFilePart;
import cn.maarlakes.common.http.body.multipart.DefaultTextPart;
import cn.maarlakes.common.http.body.multipart.JsonPart;
import cn.maarlakes.common.http.body.multipart.MultipartBodyBuilder;
import cn.maarlakes.common.http.body.multipart.MultipartPart;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;

public interface MultipartBody
extends RequestBody<Collection<? extends MultipartPart<?>>> {
    @Nonnull
    public String getBoundary();

    @Nonnull
    public static Builder builder() {
        return new MultipartBodyBuilder();
    }

    public static interface Builder {
        @Nonnull
        public Builder boundary(@Nonnull String var1);

        @Nonnull
        public Builder contentType(@Nonnull ContentType var1);

        @Nonnull
        default public Builder addBinaryPart(@Nonnull String name, @Nonnull byte[] buffer) {
            return this.addPart(new ByteArrayPart(name, buffer));
        }

        @Nonnull
        default public Builder addBinaryPart(@Nonnull String name, @Nonnull byte[] buffer, Charset charset) {
            return this.addPart(new ByteArrayPart(name, buffer, charset));
        }

        @Nonnull
        default public Builder addBinaryPart(@Nonnull String name, @Nonnull byte[] buffer, ContentType contentType) {
            return this.addPart(new ByteArrayPart(name, buffer, contentType));
        }

        @Nonnull
        default public Builder addBinaryPart(@Nonnull String name, @Nonnull byte[] buffer, ContentType contentType, Charset charset) {
            return this.addPart(new ByteArrayPart(name, buffer, contentType, charset));
        }

        @Nonnull
        default public Builder addTextPart(@Nonnull String name, @Nonnull String value) {
            return this.addPart(new DefaultTextPart(name, value));
        }

        @Nonnull
        default public Builder addTextPart(@Nonnull String name, @Nonnull String value, @Nonnull Charset charset) {
            return this.addPart(new DefaultTextPart(name, (CharSequence)value, charset));
        }

        @Nonnull
        default public Builder addTextPart(@Nonnull String name, @Nonnull String value, ContentType contentType) {
            return this.addPart(new DefaultTextPart(name, (CharSequence)value, contentType));
        }

        @Nonnull
        default public Builder addTextPart(@Nonnull String name, @Nonnull String value, ContentType contentType, @Nonnull Charset charset) {
            return this.addPart(new DefaultTextPart(name, value, contentType, charset));
        }

        @Nonnull
        default public Builder addJsonPart(@Nonnull String name, @Nonnull String json) {
            return this.addPart(new JsonPart(name, json));
        }

        @Nonnull
        default public Builder addJsonPart(@Nonnull String name, @Nonnull String json, Charset charset) {
            return this.addPart(new JsonPart(name, json, charset));
        }

        @Nonnull
        default public Builder addJsonPart(@Nonnull String name, @Nonnull Object obj) {
            return this.addPart(new JsonPart(name, obj));
        }

        @Nonnull
        default public Builder addJsonPart(@Nonnull String name, @Nonnull Object obj, Charset charset) {
            return this.addPart(new JsonPart(name, obj, charset));
        }

        @Nonnull
        default public Builder addFilePart(@Nonnull String name, @Nonnull File file) {
            return this.addPart(new DefaultFilePart(name, file));
        }

        @Nonnull
        default public Builder addFilePart(@Nonnull String name, @Nonnull File file, Charset charset) {
            return this.addPart(new DefaultFilePart(name, file, charset));
        }

        @Nonnull
        default public Builder addFilePart(@Nonnull String name, @Nonnull File file, ContentType contentType) {
            return this.addPart(new DefaultFilePart(name, file, contentType));
        }

        @Nonnull
        default public Builder addFilePart(@Nonnull String name, @Nonnull File file, ContentType contentType, Charset charset) {
            return this.addPart(new DefaultFilePart(name, file, contentType, charset));
        }

        @Nonnull
        public Builder addPart(@Nonnull MultipartPart<?> var1);

        @Nonnull
        public MultipartBody build();
    }
}

