/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.body;

import cn.maarlakes.common.http.NameValuePair;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;

public final class BodyUtils {
    private BodyUtils() {
    }

    @Nonnull
    public static String formatParams(@Nonnull Iterable<? extends NameValuePair> params) {
        StringBuilder builder = new StringBuilder();
        for (NameValuePair nameValuePair : params) {
            builder.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue()).append("&");
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    @Nonnull
    public static String formatParamsEncode(@Nonnull Iterable<? extends NameValuePair> params) {
        return BodyUtils.formatParamsEncode(params, "utf-8");
    }

    @Nonnull
    public static String formatParamsEncode(@Nonnull Iterable<? extends NameValuePair> params, @Nonnull String charset) {
        StringBuilder builder = new StringBuilder();
        try {
            for (NameValuePair nameValuePair : params) {
                builder.append(URLEncoder.encode(nameValuePair.getName(), charset)).append("=").append(URLEncoder.encode(nameValuePair.getValue(), charset)).append("&");
            }
            if (builder.length() > 0) {
                return builder.substring(0, builder.length() - 1);
            }
            return "";
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public static byte[] contentAsBytes(@Nonnull CharSequence content) {
        return BodyUtils.contentAsBytes(content, "utf-8");
    }

    @Nonnull
    public static byte[] contentAsBytes(@Nonnull CharSequence content, @Nonnull String charset) {
        try {
            return content.toString().getBytes(charset);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

