/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.async;

import cn.maarlakes.common.http.ByteArrayResponseBody;
import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.ContentTypes;
import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.HttpClientException;
import cn.maarlakes.common.http.HttpHeaders;
import cn.maarlakes.common.http.HttpMethod;
import cn.maarlakes.common.http.NameValuePair;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.http.Response;
import cn.maarlakes.common.http.ResponseBody;
import cn.maarlakes.common.http.body.multipart.FilePart;
import cn.maarlakes.common.http.body.multipart.MultipartBody;
import cn.maarlakes.common.http.body.multipart.MultipartPart;
import cn.maarlakes.common.utils.CollectionUtils;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.request.body.multipart.InputStreamPart;
import org.asynchttpclient.request.body.multipart.Part;

public class NettyAsyncHttpClient
implements HttpClient {
    private final AsyncHttpClient client;

    public NettyAsyncHttpClient() {
        this(Dsl.asyncHttpClient());
    }

    public NettyAsyncHttpClient(@Nonnull AsyncHttpClient client) {
        this.client = client;
    }

    @Override
    @Nonnull
    public CompletionStage<? extends Response> execute(@Nonnull Request request) {
        return ((CompletableFuture)this.client.executeRequest(NettyAsyncHttpClient.toBuilder(request)).toCompletableFuture().exceptionally(error -> {
            throw new HttpClientException(error.getMessage(), (Throwable)error);
        })).thenApply(DefaultResponse::new);
    }

    private static RequestBuilder toBuilder(@Nonnull Request request) {
        RequestBuilder builder = NettyAsyncHttpClient.toBuilder(request.getMethod(), request.getUri().toString());
        if (!request.getHeaders().isEmpty()) {
            for (Header header : request.getHeaders()) {
                builder.addHeader((CharSequence)header.getName(), header.getValues());
            }
        }
        if (CollectionUtils.isNotEmpty(request.getCookies())) {
            for (Cookie cookie : request.getCookies()) {
                builder.addCookie(NettyAsyncHttpClient.toCookie(cookie));
            }
        }
        if (request.getCharset() != null) {
            builder.setCharset(request.getCharset());
        }
        if (CollectionUtils.isNotEmpty(request.getQueryParams())) {
            for (NameValuePair nameValuePair : request.getQueryParams()) {
                builder.addQueryParam(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty(request.getFormParams())) {
            for (NameValuePair nameValuePair : request.getFormParams()) {
                builder.addFormParam(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
        if (request.getBody() != null) {
            if (request.getBody() instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)request.getBody();
                if (CollectionUtils.isNotEmpty((Collection)multipartBody.getContent())) {
                    for (MultipartPart part : (Collection)multipartBody.getContent()) {
                        Header contentId = part.getHeaders().getHeader("Content-ID");
                        Header contentTransferEncoding = part.getHeaders().getHeader("Content-Transfer-Encoding");
                        if (part instanceof FilePart) {
                            builder.addBodyPart((Part)new org.asynchttpclient.request.body.multipart.FilePart(part.getName(), (File)((FilePart)part).getContent(), part.getContentType() == null ? null : ContentTypes.toString(part.getContentType()), part.getCharset(), part.getFilename(), contentId == null ? null : contentId.get(), contentTransferEncoding == null ? null : contentTransferEncoding.get()));
                            continue;
                        }
                        builder.addBodyPart((Part)new InputStreamPart(part.getName(), part.getContentStream(), part.getFilename(), -1L, part.getContentType() == null ? null : ContentTypes.toString(part.getContentType()), part.getCharset(), contentId == null ? null : contentId.get(), contentTransferEncoding == null ? null : contentTransferEncoding.get()));
                    }
                }
            } else {
                builder.setBody(request.getBody().getContentStream());
                builder.setHeader((CharSequence)request.getBody().getContentTypeHeader().getName(), request.getBody().getContentTypeHeader().getValues());
            }
        }
        return builder;
    }

    @Nonnull
    private static io.netty.handler.codec.http.cookie.Cookie toCookie(@Nonnull Cookie cookie) {
        DefaultCookie defaultCookie = new DefaultCookie(cookie.name(), cookie.value());
        defaultCookie.setDomain(cookie.domain());
        defaultCookie.setPath(cookie.path());
        defaultCookie.setMaxAge(cookie.maxAge());
        defaultCookie.setSecure(cookie.isSecure());
        defaultCookie.setHttpOnly(cookie.isHttpOnly());
        if (cookie.sameSite() != null) {
            defaultCookie.setSameSite(CookieHeaderNames.SameSite.valueOf((String)cookie.sameSite().name()));
        }
        return defaultCookie;
    }

    private static RequestBuilder toBuilder(@Nonnull HttpMethod method, @Nonnull String url) {
        return Dsl.request((String)method.name(), (String)url);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static final class AsyncHttpHeaders
    implements HttpHeaders {
        private final io.netty.handler.codec.http.HttpHeaders headers;

        private AsyncHttpHeaders(@Nonnull io.netty.handler.codec.http.HttpHeaders headers) {
            this.headers = headers;
        }

        @Override
        public boolean isEmpty() {
            return this.headers.isEmpty();
        }

        @Override
        public Header getHeader(@Nonnull String name) {
            List list = this.headers.getAll(name);
            return new DefaultHeader(name, list == null ? new ArrayList() : list);
        }

        @Override
        @Nonnull
        public Iterator<Header> iterator() {
            final Iterator iterator = this.headers.names().iterator();
            return new Iterator<Header>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Header next() {
                    return this.getHeader((String)iterator.next());
                }
            };
        }

        public String toString() {
            return this.headers.toString();
        }
    }

    protected static class DefaultResponse
    implements Response {
        private final org.asynchttpclient.Response response;

        protected DefaultResponse(org.asynchttpclient.Response response) {
            this.response = response;
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusCode();
        }

        @Override
        public String getStatusText() {
            return this.response.getStatusText();
        }

        @Override
        @Nonnull
        public ResponseBody getBody() {
            return new ByteArrayResponseBody(this.response.getResponseBodyAsBytes(), Optional.ofNullable(this.response.getContentType()).map(ContentType::parse).orElse(null));
        }

        @Override
        public URI getUri() {
            try {
                return new URI(this.response.getUri().toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        @Nonnull
        public HttpHeaders getHeaders() {
            return new AsyncHttpHeaders(this.response.getHeaders());
        }

        @Override
        @Nonnull
        public List<? extends Cookie> getCookies() {
            List cookies = this.response.getCookies();
            if (CollectionUtils.isEmpty(cookies)) {
                return Collections.emptyList();
            }
            ArrayList<Cookie> list = new ArrayList<Cookie>();
            for (io.netty.handler.codec.http.cookie.Cookie cookie : cookies) {
                CookieHeaderNames.SameSite sameSite;
                Cookie.Builder builder = Cookie.builder(cookie.name()).value(cookie.value()).domain(cookie.domain()).path(cookie.path()).maxAge(cookie.maxAge()).isSecure(cookie.isSecure()).isHttpOnly(cookie.isHttpOnly());
                if (cookie instanceof DefaultCookie && (sameSite = ((DefaultCookie)cookie).sameSite()) != null) {
                    builder.sameSite(Cookie.SameSite.of(sameSite.name()));
                }
                list.add(builder.build());
            }
            return list;
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.response.getRemoteAddress();
        }

        public String toString() {
            return this.response.toString();
        }
    }
}

