/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.apache;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.NameValuePair;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.utils.CollectionUtils;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

final class Apaches {
    Apaches() {
    }

    @Nonnull
    public static URI toUri(@Nonnull Request request) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(request.getUri());
        if (CollectionUtils.isNotEmpty(request.getQueryParams())) {
            for (NameValuePair nameValuePair : request.getQueryParams()) {
                builder.addParameter(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
        return builder.build();
    }

    public static org.apache.hc.core5.http.ContentType toApacheContentType(@Nonnull ContentType contentType) {
        org.apache.hc.core5.http.ContentType result = org.apache.hc.core5.http.ContentType.create((String)contentType.getMediaType(), (String)contentType.getCharset());
        if (CollectionUtils.isNotEmpty(contentType.getParameters())) {
            return result.withParameters((org.apache.hc.core5.http.NameValuePair[])contentType.getParameters().stream().map(item -> new BasicNameValuePair(item.getName(), item.getValue())).toArray(org.apache.hc.core5.http.NameValuePair[]::new));
        }
        return result;
    }
}

