/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.function.Consumer3;
import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.utils.StreamUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface ResponseBody {
    @Nonnull
    public InputStream getContent();

    public ContentType getContentType();

    @Nonnull
    default public Charset getCharset() {
        ContentType contentType = this.getContentType();
        if (contentType != null && contentType.getCharset() != null) {
            return Charset.forName(contentType.getCharset());
        }
        return StandardCharsets.UTF_8;
    }

    default public String asText() {
        return this.asText(this.getCharset());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String asText(@Nonnull Charset charset) {
        try (InputStream content = this.getContent();){
            String string = StreamUtils.readAllText(content, charset);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public byte[] asBytes() {
        try (InputStream content = this.getContent();){
            byte[] byArray = StreamUtils.readAllBytes(content);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    default public <T> T toJsonObject(@Nonnull Class<T> type) {
        return this.toJsonObject(type, this.getCharset());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T toJsonObject(@Nonnull Class<T> type, @Nonnull Charset charset) {
        try (InputStream content = this.getContent();){
            Object object = JSON.parseObject((InputStream)content, (Charset)charset, type, (JSONReader.Feature[])new JSONReader.Feature[0]);
            return (T)object;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    default public void writeTo(@Nonnull OutputStream out) {
        this.writeTo(out::write);
    }

    default public void writeTo(@Nonnull Consumer3<byte[], Integer, Integer> consumer) {
        try (InputStream content = this.getContent();){
            StreamUtils.writeTo(content, consumer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

