/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.ByteArrayResponseBody;
import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.Cookies;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.DefaultHttpHeaders;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.HttpClientException;
import cn.maarlakes.common.http.HttpHeaders;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.http.Response;
import cn.maarlakes.common.http.ResponseBody;
import cn.maarlakes.common.http.body.BodyUtils;
import cn.maarlakes.common.http.body.UrlEncodedFormEntityBody;
import cn.maarlakes.common.utils.CollectionUtils;
import cn.maarlakes.common.utils.StreamUtils;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JdkHttpClient
implements HttpClient {
    private final Executor executor;

    public JdkHttpClient() {
        this(new ForkJoinPool());
    }

    public JdkHttpClient(@Nonnull Executor executor) {
        this.executor = executor;
    }

    @Override
    @Nonnull
    public CompletionStage<? extends Response> execute(@Nonnull Request request) {
        return CompletableFuture.supplyAsync(() -> {
            InputStream in;
            Throwable throwable;
            UrlEncodedFormEntityBody body;
            HttpURLConnection connection = null;
            URL url = JdkHttpClient.toUrl(request);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(request.getMethod().name());
            if (!request.getHeaders().isEmpty()) {
                for (Header header : request.getHeaders()) {
                    connection.setRequestProperty(header.getName(), header.get());
                }
            }
            if (CollectionUtils.isNotEmpty(request.getCookies())) {
                connection.setRequestProperty("Cookie", request.getCookies().stream().map(item -> item.name() + "=" + item.value()).collect(Collectors.joining(";")));
            }
            if ((body = request.getBody()) == null && CollectionUtils.isNotEmpty(request.getFormParams())) {
                body = new UrlEncodedFormEntityBody(request.getFormParams(), Optional.ofNullable(request.getCharset()).map(Charset::name).orElse("utf-8"));
            }
            if (body != null) {
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", body.getContentTypeHeader().get());
                throwable = null;
                try (OutputStream out = connection.getOutputStream();){
                    body.writeTo(out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            connection.connect();
            if (connection.getResponseCode() == 200) {
                in = connection.getInputStream();
                throwable = null;
                try {
                    DefaultResponse defaultResponse = new DefaultResponse(connection.getResponseCode(), connection.getResponseMessage(), StreamUtils.readAllBytes(in), request.getUri(), this.toHeaders(connection.getHeaderFields()));
                    return defaultResponse;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            in = connection.getErrorStream();
            throwable = null;
            try {
                DefaultResponse defaultResponse = new DefaultResponse(connection.getResponseCode(), connection.getResponseMessage(), in == null ? null : StreamUtils.readAllBytes(in), request.getUri(), this.toHeaders(connection.getHeaderFields()));
                return defaultResponse;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Exception e) {
                    throw new HttpClientException(e.getMessage(), e);
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }, this.executor);
    }

    @Override
    public void close() throws IOException {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    private static URL toUrl(@Nonnull Request request) throws Exception {
        if (CollectionUtils.isEmpty(request.getQueryParams())) {
            return request.getUri().toURL();
        }
        String url = request.getUri().toString();
        if (url.contains("?")) {
            if (url.endsWith("&")) {
                return new URL(url + BodyUtils.formatParams(request.getQueryParams()));
            }
            return new URL(url + "&" + BodyUtils.formatParams(request.getQueryParams()));
        }
        return new URL(url + "?" + BodyUtils.formatParams(request.getQueryParams()));
    }

    private HttpHeaders toHeaders(Map<String, List<String>> map) {
        return new DefaultHttpHeaders(map.entrySet().stream().filter(item -> item.getKey() != null).map(entry -> new DefaultHeader((String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList()).stream().collect(Collectors.toMap(DefaultHeader::getName, Function.identity())));
    }

    private static class DefaultResponse
    implements Response {
        private final int statusCode;
        private final String statusText;
        private final URI uri;
        private final HttpHeaders headers;
        private final ResponseBody body;

        private DefaultResponse(int statusCode, String statusText, byte[] body, URI uri, HttpHeaders headers) {
            this.statusCode = statusCode;
            this.statusText = statusText;
            this.uri = uri;
            this.headers = headers;
            this.body = new ByteArrayResponseBody(body == null ? new byte[]{} : body, Optional.ofNullable(this.headers.getHeader("content-type").get()).map(ContentType::parse).orElse(null));
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText;
        }

        @Override
        @Nonnull
        public ResponseBody getBody() {
            return this.body;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        @Nonnull
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        @Nonnull
        public List<? extends Cookie> getCookies() {
            Cookie cookie;
            Header header = this.getHeaders().getHeader("Set-Cookie");
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            if (header != null && CollectionUtils.isNotEmpty(header.getValues())) {
                for (String value : header.getValues()) {
                    cookie = Cookies.parse(value);
                    if (cookie == null) continue;
                    cookies.add(cookie);
                }
            }
            if ((header = this.getHeaders().getHeader("set-cookie2")) != null && CollectionUtils.isNotEmpty(header.getValues())) {
                for (String value : header.getValues()) {
                    cookie = Cookies.parse(value);
                    if (cookie == null) continue;
                    cookies.add(cookie);
                }
            }
            return cookies;
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return null;
        }
    }
}

