/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.HttpMethod;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

final class DefaultHttpMethod
implements HttpMethod {
    private static final long serialVersionUID = 2828763294416992489L;
    private final String name;

    DefaultHttpMethod(@Nonnull String name) {
        this.name = name;
    }

    @Override
    @Nonnull
    public String name() {
        return this.name;
    }

    @Override
    public int compareTo(@Nullable HttpMethod other) {
        if (other == null) {
            return 1;
        }
        return this.name.compareToIgnoreCase(other.name());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpMethod) {
            HttpMethod that = (HttpMethod)other;
            return this.name.equalsIgnoreCase(that.name());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

