/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpHeaders;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DefaultHttpHeaders
implements HttpHeaders {
    private static final long serialVersionUID = -1545168488689288645L;
    private final Map<String, ? extends Header> headers;

    public DefaultHttpHeaders(@Nonnull Map<String, Header> headers) {
        TreeMap<String, ? extends Header> map = new TreeMap<String, Header>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(headers);
        this.headers = map;
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Header getHeader(@Nonnull String name) {
        return this.headers.get(name);
    }

    public String toString() {
        return this.headers.values().stream().map(Object::toString).collect(Collectors.joining("\r\n"));
    }

    @Override
    @Nonnull
    public Iterator<Header> iterator() {
        return this.headers.values().iterator();
    }
}

