/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.Header;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class DefaultHeader
implements Header {
    private static final long serialVersionUID = -8688165886423291957L;
    private final String headerName;
    private final List<String> values;

    public DefaultHeader(@Nonnull String headerName, @Nonnull String value) {
        this(headerName, Collections.singletonList(value));
    }

    public DefaultHeader(@Nonnull String headerName, @Nonnull Collection<String> values) {
        this.headerName = headerName;
        this.values = Collections.unmodifiableList(new ArrayList<String>(values));
    }

    @Override
    @Nonnull
    public String getName() {
        return this.headerName;
    }

    @Override
    @Nonnull
    public Collection<String> getValues() {
        return this.values;
    }

    @Override
    @Nonnull
    public Header clear() {
        return new DefaultHeader(this.headerName, Collections.emptyList());
    }

    @Override
    public String get() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    @Override
    public int compareTo(@Nullable Header other) {
        if (other == null) {
            return 1;
        }
        return this.headerName.compareToIgnoreCase(other.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Header) {
            Header that = (Header)obj;
            if (!this.headerName.equalsIgnoreCase(that.getName())) {
                return false;
            }
            return this.values.equals(that.getValues());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.headerName, this.values);
    }

    public String toString() {
        return this.headerName + ":" + String.join((CharSequence)";", this.values);
    }
}

