/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.ResponseBody;
import com.alibaba.fastjson2.JSON;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;

public class ByteArrayResponseBody
implements ResponseBody {
    private final byte[] content;
    private final ContentType contentType;

    public ByteArrayResponseBody(@Nonnull byte[] content, ContentType contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    @Override
    @Nonnull
    public InputStream getContent() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String asText(@Nonnull Charset charset) {
        return new String(this.content, charset);
    }

    @Override
    public byte[] asBytes() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    @Override
    public <T> T toJsonObject(@Nonnull Class<T> type, @Nonnull Charset charset) {
        return (T)JSON.parseObject((byte[])this.content, (int)0, (int)this.content.length, (Charset)charset, type);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteArrayResponseBody)) {
            return false;
        }
        ByteArrayResponseBody that = (ByteArrayResponseBody)o;
        return Arrays.equals(this.content, that.content) && Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.content);
        result = 31 * result + Objects.hashCode(this.contentType);
        return result;
    }
}

