/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.function;

import cn.maarlakes.common.function.Function0;
import cn.maarlakes.common.function.Function1;
import cn.maarlakes.common.function.Functions;
import jakarta.annotation.Nonnull;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

@FunctionalInterface
public interface Function2<T1, T2, R>
extends BiFunction<T1, T2, R> {
    @Override
    default public R apply(T1 t1, T2 t2) {
        return this.applyUnchecked(t1, t2);
    }

    default public R applyUnchecked(T1 t1, T2 t2) {
        return this.applyUnchecked(t1, t2, Functions.THROWABLE_TO_RUNTIME_EXCEPTION);
    }

    default public R applyUnchecked(T1 t1, T2 t2, @Nonnull Consumer<Throwable> handler) {
        try {
            return this.apply0(t1, t2);
        }
        catch (Throwable throwable) {
            handler.accept(throwable);
            throw new IllegalStateException(throwable);
        }
    }

    default public R applyUnchecked(T1 t1, T2 t2, @Nonnull Function<Throwable, R> handler) {
        try {
            return this.apply0(t1, t2);
        }
        catch (Throwable throwable) {
            return handler.apply(throwable);
        }
    }

    public R apply0(T1 var1, T2 var2) throws Exception;

    @Nonnull
    default public Function1<T2, R> acceptPartially(T1 t1) {
        return t2 -> this.apply0(t1, t2);
    }

    @Nonnull
    default public Function0<R> acceptPartially(T1 t1, T2 t2) {
        return () -> this.apply0(t1, t2);
    }

    @Nonnull
    default public BiFunction<T1, T2, R> toBiFunction() {
        return this::applyUnchecked;
    }

    @Nonnull
    public static <T1, T2, R> Function2<T1, T2, R> from(@Nonnull BiFunction<T1, T2, R> biFunction) {
        return biFunction::apply;
    }
}

