/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.function;

import cn.maarlakes.common.function.Functions;
import jakarta.annotation.Nonnull;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface Function0<R>
extends Supplier<R>,
Callable<R> {
    default public R applyUnchecked() {
        return this.applyUnchecked(Functions.THROWABLE_TO_RUNTIME_EXCEPTION);
    }

    default public R applyUnchecked(@Nonnull Consumer<Throwable> handler) {
        try {
            return this.apply();
        }
        catch (Throwable throwable) {
            handler.accept(throwable);
            throw new IllegalStateException(throwable);
        }
    }

    default public R applyUnchecked(@Nonnull Function<Throwable, R> handler) {
        try {
            return this.apply();
        }
        catch (Throwable throwable) {
            return handler.apply(throwable);
        }
    }

    public R apply() throws Exception;

    @Override
    default public R call() throws Exception {
        return this.apply();
    }

    @Override
    default public R get() {
        return this.applyUnchecked();
    }

    @Nonnull
    default public Supplier<R> toSupplier() {
        return this::applyUnchecked;
    }

    @Nonnull
    default public Callable<R> toCallable() {
        return this::applyUnchecked;
    }

    @Nonnull
    public static <R> Function0<R> from(@Nonnull Supplier<R> supplier) {
        return supplier::get;
    }

    @Nonnull
    public static <R> Function0<R> from(@Nonnull Callable<R> callable) {
        return callable::call;
    }
}

