/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.factory.bean;

import cn.maarlakes.common.factory.bean.BeanException;
import cn.maarlakes.common.factory.bean.BeanProvider;
import cn.maarlakes.common.factory.bean.ReflectBeanProvider;
import cn.maarlakes.common.spi.SpiServiceLoader;
import cn.maarlakes.common.utils.ClassUtils;
import cn.maarlakes.common.utils.Lazy;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public final class BeanFactories {
    private static final SpiServiceLoader<BeanProvider> PROVIDERS = SpiServiceLoader.loadShared(BeanProvider.class, BeanProvider.class.getClassLoader());

    private BeanFactories() {
    }

    public static boolean contains(@Nonnull Class<?> beanType) {
        return BeanFactories.exec(provider -> provider.contains(beanType)).orElse(false);
    }

    public static boolean contains(@Nonnull String beanName) {
        return BeanFactories.exec(provider -> provider.contains(beanName)).orElse(false);
    }

    @Nonnull
    public static <T> T getBean(@Nonnull Class<T> beanType) {
        return (T)BeanFactories.exec(provider -> provider.getBeanOrNull(beanType)).orElseThrow(() -> new BeanException("Bean of type " + beanType.getName() + " not found."));
    }

    @Nonnull
    public static <T> Optional<T> getBeanOptional(@Nonnull Class<T> beanType) {
        return Optional.ofNullable(BeanFactories.getBeanOrNull(beanType));
    }

    @Nonnull
    public static <T> T getBean(@Nonnull Class<T> beanType, Object ... args) {
        return (T)BeanFactories.exec(provider -> provider.getBean(beanType, args)).orElseThrow(() -> new BeanException("Bean of type " + beanType.getName() + " not found."));
    }

    public static <T> T getBeanOrNull(@Nonnull Class<T> beanType) {
        return BeanFactories.exec(provider -> provider.getBeanOrNull(beanType)).orElse(null);
    }

    @Nonnull
    public static <T> T getBean(@Nonnull String beanName) {
        return (T)BeanFactories.exec(provider -> provider.getBeanOrNull(beanName)).orElseThrow(() -> new BeanException("Bean of name " + beanName + " not found."));
    }

    @Nonnull
    public static <T> Optional<T> getBeanOptional(@Nonnull String beanName) {
        return Optional.ofNullable(BeanFactories.getBeanOrNull(beanName));
    }

    public static <T> T getBeanOrNull(@Nonnull String beanName) {
        return BeanFactories.exec(provider -> provider.getBeanOrNull(beanName)).orElse(null);
    }

    public static <T> T getBeanOrDefault(@Nonnull Class<T> beanType, @Nonnull T defaultValue) {
        T bean = BeanFactories.getBeanOrNull(beanType);
        if (bean == null) {
            return defaultValue;
        }
        return bean;
    }

    public static <T> T getBeanOrDefault(@Nonnull Class<T> beanType, @Nonnull Supplier<T> defaultValue) {
        T bean = BeanFactories.getBeanOrNull(beanType);
        if (bean == null) {
            return defaultValue.get();
        }
        return bean;
    }

    @Nonnull
    public static <T> T getBeanOrNew(@Nonnull Class<T> beanType, Object ... args) {
        return BeanFactories.getBeanOrNew(beanType, ClassUtils.parameterTypes(args), args);
    }

    @Nonnull
    public static <T> T getBeanOrNew(@Nonnull Class<T> beanType, @Nonnull Class<?>[] argTypes, @Nonnull Object[] args) {
        T bean = BeanFactories.getBeanOrNull(beanType);
        if (bean != null) {
            return bean;
        }
        return (T)BeanFactories.newInstance(ClassUtils.getMatchingAccessibleDeclaredConstructor(beanType, argTypes), args);
    }

    @Nonnull
    public static <T> List<T> getBeans(@Nonnull Class<T> beanType) {
        SpiServiceLoader<BeanProvider> service = PROVIDERS;
        if (service.isEmpty()) {
            return ReflectBeanProvider.getInstance().getBeans(beanType);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (BeanProvider provider : service) {
            list.addAll(provider.getBeans(beanType));
        }
        return list;
    }

    @Nonnull
    public static <T> Map<String, T> getBeanMap(@Nonnull Class<T> beanType) {
        SpiServiceLoader<BeanProvider> service = PROVIDERS;
        if (service.isEmpty()) {
            return ReflectBeanProvider.getInstance().getBeanMap(beanType);
        }
        HashMap<String, T> map = new HashMap<String, T>();
        for (BeanProvider provider : service) {
            map.putAll(provider.getBeanMap(beanType));
        }
        return map;
    }

    @Nonnull
    public static <T> Supplier<T> getBeanLazy(@Nonnull Class<T> beanType) {
        return Lazy.of(() -> BeanFactories.getBean(beanType));
    }

    @Nonnull
    public static <T> Supplier<T> getBeanLazy(@Nonnull Class<T> beanType, Object ... args) {
        return Lazy.of(() -> BeanFactories.getBean(beanType, args));
    }

    @Nonnull
    public static <T> Supplier<T> getBeanOrNullLazy(@Nonnull Class<T> beanType) {
        return Lazy.of(() -> BeanFactories.getBeanOrNull(beanType));
    }

    @Nonnull
    public static <T> Supplier<T> getBeanLazy(@Nonnull String beanName) {
        return Lazy.of(() -> BeanFactories.getBean(beanName));
    }

    @Nonnull
    public static <T> Supplier<T> getBeanOrNullLazy(@Nonnull String beanName) {
        return Lazy.of(() -> BeanFactories.getBeanOrNull(beanName));
    }

    public static <T> Supplier<T> getBeanOrDefaultLazy(@Nonnull Class<T> beanType, @Nonnull T defaultValue) {
        return Lazy.of(() -> BeanFactories.getBeanOrDefault(beanType, defaultValue));
    }

    public static <T> Supplier<T> getBeanOrDefaultLazy(@Nonnull Class<T> beanType, @Nonnull Supplier<T> defaultValue) {
        return Lazy.of(() -> BeanFactories.getBeanOrDefault(beanType, defaultValue));
    }

    @Nonnull
    public static <T> Supplier<T> getBeanOrNewLazy(@Nonnull Class<T> beanType, Object ... args) {
        return Lazy.of(() -> BeanFactories.getBeanOrNew(beanType, args));
    }

    @Nonnull
    public static <T> Supplier<T> getBeanOrNewLazy(@Nonnull Class<T> beanType, @Nonnull Class<?>[] argTypes, @Nonnull Object[] args) {
        return Lazy.of(() -> BeanFactories.getBeanOrNew(beanType, argTypes, args));
    }

    static <T> T newInstance(@Nonnull Constructor<T> constructor, @Nonnull Object[] args) {
        try {
            AccessController.doPrivileged(() -> {
                constructor.setAccessible(true);
                return null;
            });
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    @Nonnull
    private static <T> Optional<T> exec(Function<BeanProvider, T> func) {
        SpiServiceLoader<BeanProvider> service = PROVIDERS;
        if (service.isEmpty()) {
            return Optional.ofNullable(func.apply(ReflectBeanProvider.getInstance()));
        }
        for (BeanProvider provider : service) {
            Optional<T> result = Optional.ofNullable(func.apply(provider));
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

