/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.chain;

import cn.maarlakes.common.chain.AbstractChainFactory;
import cn.maarlakes.common.spi.SpiServiceLoader;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;

public final class SpiChainFactory
extends AbstractChainFactory {
    private final ClassLoader loader;
    private final boolean isShared;

    public SpiChainFactory() {
        this(null, true);
    }

    public SpiChainFactory(ClassLoader loader) {
        this(loader, true);
    }

    public SpiChainFactory(boolean isShared) {
        this(null, isShared);
    }

    public SpiChainFactory(ClassLoader loader, boolean isShared) {
        this.loader = loader;
        this.isShared = isShared;
    }

    @Override
    protected <H> H[] createHandlers(@Nonnull Class<H> type) {
        ClassLoader classLoader = this.loader == null ? type.getClassLoader() : this.loader;
        return (this.isShared ? SpiServiceLoader.loadShared(type, classLoader) : SpiServiceLoader.load(type, classLoader)).stream().toArray(count -> (Object[])Array.newInstance(type, count));
    }
}

