/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.chain;

import cn.maarlakes.common.reflect.AbstractInvocationHandler;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class NoneResultChainInvocationHandler<H>
extends AbstractInvocationHandler {
    protected final Class<H> type;
    protected final H[] handlers;

    public NoneResultChainInvocationHandler(@Nonnull Class<H> type, @Nonnull H[] handlers) {
        this.type = type;
        this.handlers = handlers;
    }

    @Override
    protected Object handleInvocation(@Nonnull Object proxy, @Nonnull Method method, @Nonnull Object[] args) throws Throwable {
        try {
            for (H handler : this.handlers) {
                method.invoke(handler, args);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NoneResultChainInvocationHandler) {
            NoneResultChainInvocationHandler that = (NoneResultChainInvocationHandler)obj;
            return this.type == that.type && Arrays.deepEquals(this.handlers, that.handlers);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.type);
        result = 31 * result + Arrays.hashCode(this.handlers);
        return result;
    }

    @Override
    protected String toString(@Nonnull Object proxy, @Nonnull Method method, @Nonnull Object[] args) {
        String str = super.toString();
        int index = str.indexOf("@");
        return this.type + "$NoneResultChainProxy@" + str.substring(Math.max(0, index + 1));
    }
}

