/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.chain;

import cn.maarlakes.common.reflect.AbstractInvocationHandler;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class FirstResultChainInvocationHandler<H>
extends AbstractInvocationHandler {
    protected final Class<H> type;
    protected final H[] handlers;

    public FirstResultChainInvocationHandler(@Nonnull Class<H> type, @Nonnull H[] handlers) {
        this.type = type;
        this.handlers = handlers;
    }

    @Override
    protected Object handleInvocation(@Nonnull Object proxy, @Nonnull Method method, @Nonnull Object[] args) throws Throwable {
        try {
            for (H handler : this.handlers) {
                Object result = method.invoke(handler, args);
                if (result == null) continue;
                return result;
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FirstResultChainInvocationHandler) {
            FirstResultChainInvocationHandler that = (FirstResultChainInvocationHandler)obj;
            return this.type == that.type && Arrays.deepEquals(this.handlers, that.handlers);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.type);
        result = 31 * result + Arrays.hashCode(this.handlers);
        return result;
    }

    @Override
    protected String toString(@Nonnull Object proxy, @Nonnull Method method, @Nonnull Object[] args) {
        String str = super.toString();
        int index = str.indexOf("@");
        return this.type + "$FirstResultChainProxy@" + str.substring(Math.max(0, index + 1));
    }
}

