/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.event;

import cn.maarlakes.common.event.BeanFactoriesEventInvoker;
import cn.maarlakes.common.event.EventInvoker;
import cn.maarlakes.common.event.EventListener;
import cn.maarlakes.common.event.EventListenerHandler;
import cn.maarlakes.common.spi.SpiService;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class BeanFactoriesEventListenerHandler {
    BeanFactoriesEventListenerHandler() {
    }

    @SpiService(lifecycle=SpiService.Lifecycle.SINGLETON)
    public static class Handler
    implements EventListenerHandler {
        @Override
        public <L> List<EventInvoker> getInvokers(@Nonnull L listener) {
            ArrayList<BeanFactoriesEventInvoker> invokers = new ArrayList<BeanFactoriesEventInvoker>();
            for (Method method : listener.getClass().getDeclaredMethods()) {
                EventListener eventListener = method.getAnnotation(EventListener.class);
                if (eventListener == null) continue;
                if (method.getParameterCount() < 1) {
                    throw new IllegalArgumentException("Method <" + method + "> of class <" + method.getDeclaringClass() + "> is annotated with <" + EventListener.class.getName() + "> but has 0  parameters! Listener methods MUST have 1 parameter.");
                }
                invokers.add(new BeanFactoriesEventInvoker(listener, method, eventListener));
            }
            return Collections.unmodifiableList(invokers);
        }
    }
}

