/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.chain;

import cn.maarlakes.common.chain.ChainContext;
import cn.maarlakes.common.reflect.AbstractInvocationHandler;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class ContextChainInvocationHandler<H, R>
extends AbstractInvocationHandler {
    protected final Class<H> type;
    protected final H[] handlers;
    protected final ChainContext<H, R> context;

    public ContextChainInvocationHandler(@Nonnull Class<H> type, @Nonnull H[] handlers, @Nonnull ChainContext<H, R> context) {
        this.type = type;
        this.handlers = handlers;
        this.context = context;
    }

    @Override
    protected Object handleInvocation(@Nonnull Object proxy, @Nonnull Method method, @Nonnull Object[] args) throws Throwable {
        try {
            for (H handler : this.handlers) {
                if (!this.context.addResult(handler, method.invoke(handler, args))) break;
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return this.context.result();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContextChainInvocationHandler) {
            ContextChainInvocationHandler that = (ContextChainInvocationHandler)obj;
            return this.type == that.type && Arrays.deepEquals(this.handlers, that.handlers);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.type);
        result = 31 * result + Arrays.hashCode(this.handlers);
        return result;
    }

    @Override
    protected String toString(@Nonnull Object proxy, @Nonnull Method method, @Nonnull Object[] args) {
        String str = super.toString();
        int index = str.indexOf("@");
        return this.type + "$ContextChainProxy@" + str.substring(Math.max(0, index + 1));
    }
}

