/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common;

import cn.maarlakes.common.Ordered;
import cn.maarlakes.common.utils.ClassUtils;
import cn.maarlakes.common.utils.MethodUtils;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Comparator;

public class OrderedComparator
implements Comparator<Object> {
    private static final Class<?> SPRING_ORDER_TYPE = ClassUtils.loadClass("org.springframework.core.Ordered");

    protected OrderedComparator() {
    }

    @Nonnull
    public static OrderedComparator getInstance() {
        return Helper.COMPARATOR;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return Integer.compare(Integer.MAX_VALUE, this.getOrder(obj2));
        }
        if (obj2 == null) {
            return Integer.compare(this.getOrder(obj1), Integer.MAX_VALUE);
        }
        Class<?> obj1Type = obj1.getClass();
        Class<?> obj2Type = obj2.getClass();
        Class<Comparable> comparableType = Comparable.class;
        if (comparableType.isAssignableFrom(obj1Type) && comparableType.isAssignableFrom(obj2Type)) {
            try {
                Method compareTo = Arrays.stream(obj1Type.getMethods()).filter(method -> "compareTo".equals(method.getName()) && method.getParameterCount() == 1 && method.getReturnType() == Integer.TYPE).filter(method -> method.getParameterTypes()[0].isAssignableFrom(obj2Type)).findFirst().orElse(null);
                if (compareTo != null && compareTo.getParameterTypes()[0] != Object.class) {
                    return (Integer)MethodUtils.invoke(compareTo, obj1, obj2);
                }
                Method compare = Arrays.stream(obj2Type.getMethods()).filter(method -> "compareTo".equals(method.getName()) && method.getParameterCount() == 1 && method.getReturnType() == Integer.TYPE).filter(method -> method.getParameterTypes()[0].isAssignableFrom(obj1Type)).findFirst().orElse(null);
                if (compare != null) {
                    return (Integer)MethodUtils.invoke(compare, obj2, obj1);
                }
                if (compareTo != null) {
                    return (Integer)MethodUtils.invoke(compareTo, obj1, obj2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.compare(this.getOrder(obj1), this.getOrder(obj2));
    }

    protected int getOrder(Object obj) {
        if (obj == null) {
            return Integer.MAX_VALUE;
        }
        Integer order = this.findOrder(obj);
        return order == null ? Integer.MAX_VALUE : order;
    }

    protected Integer findOrder(@Nonnull Object obj) {
        if (obj instanceof Ordered) {
            return ((Ordered)obj).order();
        }
        if (SPRING_ORDER_TYPE != null && SPRING_ORDER_TYPE.isAssignableFrom(obj.getClass())) {
            try {
                Method method = obj.getClass().getMethod("getOrder", new Class[0]);
                AccessController.doPrivileged(() -> {
                    method.setAccessible(true);
                    return null;
                });
                return (Integer)method.invoke(obj, new Object[0]);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    private static final class Helper {
        static final OrderedComparator COMPARATOR = new OrderedComparator();

        private Helper() {
        }
    }
}

