/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.tuple;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public final class KeyValuePair<K, V>
implements Serializable {
    private static final long serialVersionUID = -52505007629865251L;
    @Nonnull
    private final K key;
    private final V value;

    public KeyValuePair(@Nonnull K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Nonnull
    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KeyValuePair that = (KeyValuePair)object;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

