/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token.weixin;

import cn.maarlakes.common.token.Tokens;
import cn.maarlakes.common.token.weixin.WeixinSecretMapper;
import cn.maarlakes.common.token.weixin.WeixinToken;
import cn.maarlakes.common.token.weixin.WeixinTokenFactory;
import cn.maarlakes.common.token.weixin.WeixinTokenUtils;
import cn.maarlakes.common.utils.StreamUtils;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public class StableWeixinTokenFactory
implements WeixinTokenFactory {
    private final WeixinSecretMapper secretMapper;
    private final Executor executor;
    private final String url;
    private final boolean forceRefresh;

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper) {
        this(mapper, ForkJoinPool.commonPool());
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, boolean forceRefresh) {
        this(mapper, ForkJoinPool.commonPool(), forceRefresh);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull Executor executor) {
        this(mapper, executor, "https://api.weixin.qq.com/cgi-bin/stable_token", false);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull Executor executor, boolean forceRefresh) {
        this(mapper, executor, "https://api.weixin.qq.com/cgi-bin/stable_token", forceRefresh);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull String tokenUrl) {
        this(mapper, ForkJoinPool.commonPool(), tokenUrl, false);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull String tokenUrl, boolean forceRefresh) {
        this(mapper, ForkJoinPool.commonPool(), tokenUrl, forceRefresh);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull Executor executor, @Nonnull String tokenUrl, boolean forceRefresh) {
        this.secretMapper = mapper;
        this.executor = executor;
        this.url = tokenUrl;
        this.forceRefresh = forceRefresh;
    }

    @Override
    @Nonnull
    public CompletionStage<WeixinToken> createToken(@Nonnull String appId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Object json;
                LocalDateTime now = LocalDateTime.now();
                URL url = new URL(this.url);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.connect();
                try (Closeable stream = connection.getOutputStream();){
                    json = new JSONObject();
                    json.put((Object)"grant_type", (Object)"client_credential");
                    json.put((Object)"appid", (Object)appId);
                    json.put((Object)"secret", (Object)this.secretMapper.getSecret(appId));
                    json.put((Object)"force_refresh", (Object)this.forceRefresh);
                    ((OutputStream)stream).write(json.toJSONString(new JSONWriter.Feature[0]).getBytes());
                }
                stream = connection.getInputStream();
                var6_7 = null;
                try {
                    json = StreamUtils.readAllText((InputStream)stream);
                    WeixinToken weixinToken = WeixinTokenUtils.toWeixinToken((String)json, appId, now);
                    return weixinToken;
                }
                catch (Throwable throwable) {
                    var6_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (var6_7 != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable throwable) {
                                var6_7.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)stream).close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw Tokens.newTokenException(e);
            }
        }, this.executor);
    }
}

