/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token;

import cn.maarlakes.common.token.ExpirationAppToken;
import cn.maarlakes.common.token.ExpirationTokenRepository;
import cn.maarlakes.common.token.MemoryCacheableAppTokenRepository;
import cn.maarlakes.common.token.TokenFactory;
import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletionStage;

public class MemoryExpirationTokenRepository<T extends ExpirationAppToken<A, V>, A, V>
extends MemoryCacheableAppTokenRepository<T, A, V>
implements ExpirationTokenRepository<T, A, V> {
    public MemoryExpirationTokenRepository(@Nonnull TokenFactory<T, A, V> tokenFactory) {
        super(tokenFactory);
    }

    @Override
    @Nonnull
    public CompletionStage<Void> removeExpiredTokenAsync() {
        return this.getExpiredTokensAsync().thenAccept(tokens -> tokens.forEach(token -> this.cacheTokens.remove(token.getAppId(), token)));
    }

    @Override
    @Nonnull
    public CompletionStage<T> refreshAsync(@Nonnull T token) {
        this.cacheTokens.remove(token.getAppId(), token);
        return this.getTokenAsync(token.getAppId());
    }
}

