/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token;

import cn.maarlakes.common.token.ExpirationAppToken;
import cn.maarlakes.common.token.RefreshableTokenRepository;
import cn.maarlakes.common.token.Tokens;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public interface ExpirationTokenRepository<T extends ExpirationAppToken<A, V>, A, V>
extends RefreshableTokenRepository<T, A, V> {
    @Nonnull
    public CompletionStage<Void> removeExpiredTokenAsync();

    default public void removeExpiredToken() {
        this.removeExpiredTokenAsync().toCompletableFuture().join();
    }

    @Nonnull
    default public CompletionStage<List<T>> getExpiredTokensAsync() {
        return this.getTokensAsync().thenApply(tokens -> tokens.stream().filter(Tokens::isExpired).collect(Collectors.toList()));
    }

    @Nonnull
    default public List<T> getExpiredTokens() {
        return this.getExpiredTokensAsync().toCompletableFuture().join();
    }
}

