/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.event;

import cn.maarlakes.common.AnnotationOrderComparator;
import cn.maarlakes.common.event.EventDispatcher;
import cn.maarlakes.common.event.EventException;
import cn.maarlakes.common.event.EventInvoker;
import cn.maarlakes.common.event.EventListenerHandler;
import cn.maarlakes.common.event.EventListenerHandlerFactory;
import cn.maarlakes.common.event.EventListenerRegistrar;
import cn.maarlakes.common.event.EventPublisher;
import cn.maarlakes.common.event.EventPublisherFactory;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class DefaultEventListenerRegistrar
implements EventListenerRegistrar,
EventPublisherFactory {
    private final EventPublisher eventPublisher;
    private final EventListenerHandlerFactory listenerHandlersFactory;
    private final ConcurrentMap<Object, List<EventInvoker>> invokers = new ConcurrentHashMap<Object, List<EventInvoker>>();
    private final ConcurrentMap<Class<?>, Collection<EventInvoker>> eventInvokerCache = new ConcurrentHashMap();

    public DefaultEventListenerRegistrar(@Nonnull EventDispatcher dispatcher, EventListenerHandlerFactory listenerHandlersFactory) {
        this.eventPublisher = new DefaultEventPublisher(dispatcher);
        this.listenerHandlersFactory = listenerHandlersFactory;
    }

    @Override
    public <L> void register(@Nonnull L listener) {
        this.invokers.compute(listener, (k, listenerInvokers) -> this.getListenerInvoker(listener));
        this.eventInvokerCache.clear();
    }

    @Override
    public <L> void unregister(@Nonnull L listener) {
        this.invokers.remove(Objects.requireNonNull(listener));
        this.eventInvokerCache.clear();
    }

    @Override
    public void unregisterAll() {
        this.invokers.clear();
        this.eventInvokerCache.clear();
    }

    @Override
    @Nonnull
    public EventPublisher getPublisher() {
        return this.eventPublisher;
    }

    private <L> List<EventInvoker> getListenerInvoker(L listener) {
        List<EventListenerHandler> listenerHandlers = this.listenerHandlersFactory.getListenerHandlers();
        if (listenerHandlers.isEmpty()) {
            throw new IllegalArgumentException("No listener handlers");
        }
        ArrayList<EventInvoker> invokers = new ArrayList<EventInvoker>();
        for (EventListenerHandler handler : listenerHandlers) {
            invokers.addAll(handler.getInvokers(listener));
        }
        if (invokers.isEmpty()) {
            throw new IllegalArgumentException("No listener invokers were found for listener <" + listener + ">");
        }
        return Collections.unmodifiableList(invokers);
    }

    private class DefaultEventPublisher
    implements EventPublisher {
        private final EventDispatcher dispatcher;

        private DefaultEventPublisher(EventDispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public <E> void publish(@Nonnull E event) {
            DefaultEventListenerRegistrar.this.eventInvokerCache.computeIfAbsent(event.getClass(), eventType -> DefaultEventListenerRegistrar.this.invokers.values().stream().flatMap(Collection::stream).filter(item -> item.supportedEvent((Class<?>)eventType)).sorted(AnnotationOrderComparator.getInstance()).collect(Collectors.toList())).forEach(invoker -> {
                try {
                    this.dispatcher.dispatch((EventInvoker)invoker, event);
                }
                catch (Throwable error) {
                    if (error instanceof EventException) {
                        throw (EventException)error;
                    }
                    throw new EventException(error);
                }
            });
        }
    }
}

