/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.event;

import cn.maarlakes.common.AnnotationOrderComparator;
import cn.maarlakes.common.Ordered;
import cn.maarlakes.common.event.EventException;
import cn.maarlakes.common.event.EventInvoker;
import cn.maarlakes.common.event.EventListener;
import cn.maarlakes.common.factory.bean.BeanFactories;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;

class BeanFactoriesEventInvoker
implements EventInvoker,
Ordered {
    private final Object listener;
    private final Method method;
    private final EventListener eventListener;

    public BeanFactoriesEventInvoker(@Nonnull Object listener, @Nonnull Method method, @Nonnull EventListener eventListener) {
        this.listener = listener;
        this.method = method;
        this.eventListener = eventListener;
        AccessController.doPrivileged(() -> {
            method.setAccessible(true);
            return null;
        });
    }

    @Override
    public boolean supportedAsync() {
        return this.eventListener.async();
    }

    public void invoke(@Nonnull Object event) {
        if (this.method.getParameterCount() == 1) {
            this.invokeMethod(event);
        } else {
            Object[] args = new Object[this.method.getParameterCount()];
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            Class<?> eventType = event.getClass();
            int index = -1;
            Class<?> backType = null;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> type = parameterTypes[i];
                if (type == eventType) {
                    args[i] = event;
                    if (index >= 0 && backType != null) {
                        args[index] = BeanFactories.getBeanOrNull(backType);
                        backType = null;
                    }
                    index = i;
                    continue;
                }
                if (args[i] == null && type.isAssignableFrom(eventType)) {
                    args[i] = event;
                    index = i;
                    backType = type;
                    continue;
                }
                args[i] = BeanFactories.getBeanOrNull(type);
            }
            if (index < 0) {
                throw new EventException("Unsupported event type: " + eventType);
            }
            this.invokeMethod(args);
        }
    }

    @Override
    public boolean supportedEvent(@Nonnull Class<?> eventType) {
        for (Class<?> type : this.eventListener.events()) {
            if (type != eventType) continue;
            return true;
        }
        for (Class<?> parameterType : this.method.getParameterTypes()) {
            if (parameterType != eventType) continue;
            return true;
        }
        return false;
    }

    private void invokeMethod(Object ... args) {
        try {
            this.method.invoke(this.listener, args);
        }
        catch (InvocationTargetException e) {
            throw new EventException(e.getTargetException());
        }
        catch (Exception e) {
            throw new EventException(e);
        }
    }

    @Override
    public int order() {
        Integer order = AnnotationOrderComparator.findOrder(this.method);
        return order == null ? Integer.MAX_VALUE : order;
    }
}

