/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import jakarta.annotation.Nonnull;

public final class CompareUtils {
    private CompareUtils() {
    }

    @Nonnull
    public static <T extends Comparable<? super T>> T min(@Nonnull T first, T ... others) {
        for (T other : others) {
            if (first.compareTo(other) <= 0) continue;
            first = other;
        }
        return (T)first;
    }

    @Nonnull
    public static <T extends Comparable<? super T>> T max(@Nonnull T first, T ... others) {
        for (T other : others) {
            if (first.compareTo(other) >= 0) continue;
            first = other;
        }
        return (T)first;
    }
}

