/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ClassUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();

    private ClassUtils() {
    }

    @Nonnull
    public static Constructor<?> getMatchingAccessibleDeclaredConstructor(Class<?> clazz, Object ... args) {
        return ClassUtils.getMatchingAccessibleDeclaredConstructor(clazz, ClassUtils.parameterTypes(args));
    }

    @Nonnull
    public static Constructor<?> getMatchingAccessibleDeclaredConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        NoSuchMethodException exception = null;
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            exception = e;
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            Constructor ctr = Arrays.stream(constructors).filter(constructor -> ClassUtils.matchTypes(constructor.getParameterTypes(), parameterTypes)).findFirst().orElse(null);
            if (ctr != null) {
                return ctr;
            }
            throw new IllegalStateException(exception);
        }
    }

    public static Class<?>[] parameterTypes(Object ... args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            types[i] = arg.getClass();
        }
        return types;
    }

    private static boolean matchTypes(Class<?>[] left, Class<?>[] right) {
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            Class<?> l = ClassUtils.wrapperType(left[i]);
            Class<?> r = ClassUtils.wrapperType(right[i]);
            if (!(r == null ? l.isPrimitive() : !l.isAssignableFrom(r))) continue;
            return false;
        }
        return true;
    }

    private static Class<?> wrapperType(Class<?> type) {
        Class<?> tmp;
        if (type != null && type.isPrimitive() && (tmp = PRIMITIVE_WRAPPER_MAP.get(type)) != null) {
            return tmp;
        }
        return type;
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Void.TYPE, Void.TYPE);
    }
}

