/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import java.nio.ByteOrder;

public final class BitUtils {
    public static final int BYTE_MAX_VALUE = 255;
    private static final int BYTE_BITS = 8;
    private static final int ONE_BYTE_BITS = 8;
    private static final int TWO_BYTE_BITS = 16;
    private static final int THREE_BYTE_BITS = 24;
    private static final int FOUR_BYTE_BITS = 32;
    private static final int FIVE_BYTE_BITS = 40;
    private static final int SIX_BYTE_BITS = 48;
    private static final int SEVEN_BYTE_BITS = 56;
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    private BitUtils() {
    }

    public static byte[] getBytes(boolean value) {
        byte[] byArray;
        if (value) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    public static byte[] getBytes(short value) {
        if (LITTLE_ENDIAN) {
            return BitUtils.getLittleEndianBytes(value);
        }
        return BitUtils.getBigEndianBytes(value);
    }

    public static byte[] getBytes(char value) {
        return BitUtils.getBytes((short)value);
    }

    public static byte[] getBytes(int value) {
        if (LITTLE_ENDIAN) {
            return BitUtils.getLittleEndianBytes(value);
        }
        return BitUtils.getBigEndianBytes(value);
    }

    public static byte[] getBytes(long value) {
        if (LITTLE_ENDIAN) {
            return BitUtils.getLittleEndianBytes(value);
        }
        return BitUtils.getBigEndianBytes(value);
    }

    public static byte[] getBytes(float value) {
        return BitUtils.getBytes(Float.floatToRawIntBits(value));
    }

    public static byte[] getBytes(double value) {
        return BitUtils.getBytes(Double.doubleToRawLongBits(value));
    }

    public static byte[] getLittleEndianBytes(short value) {
        return new byte[]{(byte)value, (byte)(value >>> 8)};
    }

    public static byte[] getLittleEndianBytes(char value) {
        return BitUtils.getLittleEndianBytes((short)value);
    }

    public static byte[] getLittleEndianBytes(int value) {
        return new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24)};
    }

    public static byte[] getLittleEndianBytes(long value) {
        return new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24), (byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56)};
    }

    public static byte[] getLittleEndianBytes(float value) {
        return BitUtils.getLittleEndianBytes(Float.floatToRawIntBits(value));
    }

    public static byte[] getLittleEndianBytes(double value) {
        return BitUtils.getLittleEndianBytes(Double.doubleToRawLongBits(value));
    }

    public static byte[] getBigEndianBytes(short value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    public static byte[] getBigEndianBytes(char value) {
        return BitUtils.getBigEndianBytes((short)value);
    }

    public static byte[] getBigEndianBytes(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static byte[] getBigEndianBytes(long value) {
        return new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static byte[] getBigEndianBytes(float value) {
        return BitUtils.getBigEndianBytes(Float.floatToRawIntBits(value));
    }

    public static byte[] getBigEndianBytes(double value) {
        return BitUtils.getBigEndianBytes(Double.doubleToRawLongBits(value));
    }

    public static short toShort(byte[] value, int startIndex) {
        if (LITTLE_ENDIAN) {
            return BitUtils.toLittleEndianShort(value, startIndex);
        }
        return BitUtils.toBigEndianShort(value, startIndex);
    }

    public static char toCharacter(byte[] value, int startIndex) {
        return (char)BitUtils.toShort(value, startIndex);
    }

    public static int toInteger(byte[] value, int startIndex) {
        if (LITTLE_ENDIAN) {
            return BitUtils.toLittleEndianInteger(value, startIndex);
        }
        return BitUtils.toBigEndianInteger(value, startIndex);
    }

    public static long toLong(byte[] value, int startIndex) {
        if (LITTLE_ENDIAN) {
            return BitUtils.toLittleEndianLong(value, startIndex);
        }
        return BitUtils.toBigEndianLong(value, startIndex);
    }

    public static float toFloat(byte[] value, int startIndex) {
        return Float.intBitsToFloat(BitUtils.toInteger(value, startIndex));
    }

    public static double toDouble(byte[] value, int startIndex) {
        return Double.longBitsToDouble(BitUtils.toLong(value, startIndex));
    }

    public static short toLittleEndianShort(byte[] value, int startIndex) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return (short)(BitUtils.getRawByte(value[startIndex]) | BitUtils.getRawByte(value[startIndex + 1]) << 8);
    }

    public static char toLittleEndianCharacter(byte[] value, int startIndex) {
        return (char)BitUtils.toLittleEndianShort(value, startIndex);
    }

    public static int toLittleEndianInteger(byte[] value, int startIndex) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return BitUtils.getRawByte(value[startIndex]) | BitUtils.getRawByte(value[startIndex + 1]) << 8 | BitUtils.getRawByte(value[startIndex + 2]) << 16 | BitUtils.getRawByte(value[startIndex + 3]) << 24;
    }

    public static long toLittleEndianLong(byte[] value, int startIndex) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int num = BitUtils.getRawByte(value[startIndex]) | BitUtils.getRawByte(value[startIndex + 1]) << 8 | BitUtils.getRawByte(value[startIndex + 2]) << 16 | BitUtils.getRawByte(value[startIndex + 3]) << 24;
        int num2 = BitUtils.getRawByte(value[startIndex + 4]) | BitUtils.getRawByte(value[startIndex + 5]) << 8 | BitUtils.getRawByte(value[startIndex + 6]) << 16 | BitUtils.getRawByte(value[startIndex + 7]) << 24;
        return (long)num & 0xFFFFFFFFL | (long)num2 << 32;
    }

    public static float toLittleEndianFloat(byte[] value, int startIndex) {
        return Float.intBitsToFloat(BitUtils.toLittleEndianInteger(value, startIndex));
    }

    public static double toLittleEndianDouble(byte[] value, int startIndex) {
        return Double.longBitsToDouble(BitUtils.toLittleEndianLong(value, startIndex));
    }

    public static short toBigEndianShort(byte[] value, int startIndex) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return (short)(BitUtils.getRawByte(value[startIndex]) << 8 | BitUtils.getRawByte(value[startIndex + 1]));
    }

    public static char toBigEndianCharacter(byte[] value, int startIndex) {
        return (char)BitUtils.toBigEndianShort(value, startIndex);
    }

    public static int toBigEndianInteger(byte[] value, int startIndex) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return BitUtils.getRawByte(value[startIndex]) << 24 | BitUtils.getRawByte(value[startIndex + 1]) << 16 | BitUtils.getRawByte(value[startIndex + 2]) << 8 | BitUtils.getRawByte(value[startIndex + 3]);
    }

    public static long toBigEndianLong(byte[] value, int startIndex) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int num3 = BitUtils.getRawByte(value[startIndex]) << 24 | BitUtils.getRawByte(value[startIndex + 1]) << 16 | BitUtils.getRawByte(value[startIndex + 2]) << 8 | BitUtils.getRawByte(value[startIndex + 3]);
        int num4 = BitUtils.getRawByte(value[startIndex + 4]) << 24 | BitUtils.getRawByte(value[startIndex + 5]) << 16 | BitUtils.getRawByte(value[startIndex + 6]) << 8 | BitUtils.getRawByte(value[startIndex + 7]);
        return (long)num4 & 0xFFFFFFFFL | (long)num3 << 32;
    }

    public static float toBigEndianFloat(byte[] value, int startIndex) {
        return Float.intBitsToFloat(BitUtils.toBigEndianInteger(value, startIndex));
    }

    public static double toBigEndianDouble(byte[] value, int startIndex) {
        return Double.longBitsToDouble(BitUtils.toBigEndianLong(value, startIndex));
    }

    public static String toString(byte[] value) {
        return BitUtils.toString(value, 0, value.length, null);
    }

    public static String toString(byte[] value, char separator) {
        return BitUtils.toString(value, 0, value.length, separator);
    }

    public static String toString(byte[] value, String separator) {
        return BitUtils.toString(value, 0, value.length, separator);
    }

    public static String toString(byte[] value, CharSequence separator) {
        return BitUtils.toString(value, 0, value.length, separator);
    }

    public static String toString(byte[] value, int startIndex) {
        return BitUtils.toString(value, startIndex, value.length - startIndex, null);
    }

    public static String toString(byte[] value, int startIndex, char separator) {
        return BitUtils.toString(value, startIndex, value.length - startIndex, separator);
    }

    public static String toString(byte[] value, int startIndex, String separator) {
        return BitUtils.toString(value, startIndex, value.length - startIndex, separator);
    }

    public static String toString(byte[] value, int startIndex, CharSequence separator) {
        return BitUtils.toString(value, startIndex, value.length - startIndex, separator);
    }

    public static String toString(byte[] value, int startIndex, int length) {
        return BitUtils.toString(value, startIndex, length, (CharSequence)null);
    }

    public static String toString(byte[] value, int startIndex, int length, char separator) {
        return BitUtils.toString(value, startIndex, length, separator + "");
    }

    public static String toString(byte[] value, int startIndex, int length, String separator) {
        return BitUtils.toString(value, startIndex, length, (CharSequence)separator);
    }

    public static String toString(byte[] value, int startIndex, int length, CharSequence separator) {
        StringBuilder builder = new StringBuilder();
        int count = startIndex + length;
        int last = count - 1;
        for (int i = startIndex; i < count; ++i) {
            String hex = Integer.toHexString(value[i] & 0xFF);
            if (hex.length() == 2) {
                builder.append(hex);
            } else {
                builder.append(0).append(hex);
            }
            if (separator == null || i >= last) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    private static int getRawByte(byte value) {
        return value & 0xFF;
    }
}

