/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import jakarta.annotation.Nonnull;

public final class PathUtils {
    private PathUtils() {
    }

    @Nonnull
    public static String combine(String ... paths) {
        return PathUtils.combineWith("/", paths);
    }

    @Nonnull
    public static String combineWith(@Nonnull String delimiter, String ... paths) {
        StringBuilder builder = new StringBuilder();
        int length = delimiter.length();
        for (String path : paths) {
            if (builder.lastIndexOf(delimiter) == builder.length() - length) {
                if (path.startsWith(delimiter)) {
                    builder.append(path.substring(length));
                    continue;
                }
                builder.append(path);
                continue;
            }
            if (path.startsWith(delimiter)) {
                builder.append(path);
                continue;
            }
            builder.append(delimiter).append(path);
        }
        return builder.toString();
    }
}

