/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.id;

import cn.maarlakes.common.id.IdGenerator;
import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import jakarta.annotation.Nonnull;
import java.security.SecureRandom;
import java.util.Random;

public final class NanoIdGenerator
implements IdGenerator {
    private static final char[] DEFAULT_ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int LENGTH = 21;
    private final SecureRandom secureRandom = new SecureRandom();
    private final int length;

    public NanoIdGenerator() {
        this(21);
    }

    public NanoIdGenerator(int length) {
        this.length = length - 1;
    }

    public static NanoIdGenerator getInstance() {
        return Helper.GENERATOR;
    }

    @Override
    @Nonnull
    public String generateId() {
        return this.secureRandom.nextInt(9) + 1 + NanoIdUtils.randomNanoId((Random)this.secureRandom, (char[])DEFAULT_ALPHABET, (int)this.length);
    }

    private static final class Helper {
        static final NanoIdGenerator GENERATOR = new NanoIdGenerator();

        private Helper() {
        }
    }
}

