/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.factory;

import cn.maarlakes.common.AnnotationOrderComparator;
import cn.maarlakes.common.utils.Lazy;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;

public final class ProviderFactories {
    private ProviderFactories() {
    }

    public static <T> Supplier<T> getProvider(@Nonnull Class<T> type, @Nonnull Supplier<T> defaultProvider) {
        return Lazy.of(() -> {
            T[] array = ProviderFactories.doGetProviders(type, null).get();
            if (array == null || array.length < 1) {
                return defaultProvider.get();
            }
            return array[0];
        });
    }

    @Nonnull
    public static <T> Supplier<T[]> getProviders(@Nonnull Class<T> type) {
        return ProviderFactories.getProviders(type, () -> (Object[])Array.newInstance(type, 0));
    }

    @Nonnull
    public static <T> Supplier<T[]> getProviders(@Nonnull Class<T> type, @Nonnull Supplier<T[]> defaultProviders) {
        return ProviderFactories.doGetProviders(type, Objects.requireNonNull(defaultProviders));
    }

    private static <T> Supplier<T[]> doGetProviders(@Nonnull Class<T> type, Supplier<T[]> defaultProviders) {
        return Lazy.of(() -> {
            Object[] array = StreamSupport.stream(ServiceLoader.load(type).spliterator(), false).sorted(AnnotationOrderComparator.getInstance()).toArray(count -> (Object[])Array.newInstance(type, count));
            if (array.length < 1 && defaultProviders != null) {
                return (Object[])defaultProviders.get();
            }
            return array;
        });
    }
}

