/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel;

import cn.lzgabel.bpmn.generator.internal.generated.model.ObjectFactory;
import cn.lzgabel.bpmn.generator.internal.generated.model.TDefinitions;
import cn.lzgabel.layouter.Layouter;
import cn.lzgabel.util.BpmnNamespacePrefixMapper;
import cn.lzgabel.util.Util;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.activiti.bpmn.model.BpmnModel;

public class BpmnAutoLayout {
    private static final Marshaller marshaller;
    private static final Unmarshaller unmarshaller;

    public static String layout(String bpmn) throws Exception {
        BpmnModel bpmnModel = Util.read(bpmn);
        new Layouter(bpmnModel).execute();
        TDefinitions originDefinitions = BpmnAutoLayout.unmarshall(bpmn);
        TDefinitions layoutedDefinitions = BpmnAutoLayout.unmarshall(Util.write(bpmnModel));
        originDefinitions.setExporter("Bpmn Auto Layouter");
        originDefinitions.setExporterVersion("1.0.0");
        originDefinitions.getBPMNDiagram().clear();
        originDefinitions.getBPMNDiagram().addAll(layoutedDefinitions.getBPMNDiagram());
        return BpmnAutoLayout.marshal(originDefinitions);
    }

    public static String marshal(TDefinitions definitions) {
        try {
            JAXBElement<TDefinitions> root = new ObjectFactory().createDefinitions(definitions);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
            BpmnAutoLayout.createMarshaller().marshal(root, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to marshal", e);
        }
    }

    private static Marshaller createMarshaller() throws JAXBException {
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try {
            marshaller.setProperty("cn.lzgabel.jaxb.namespacePrefixMapper", (Object)new BpmnNamespacePrefixMapper());
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)true);
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        return marshaller;
    }

    public static TDefinitions unmarshall(String xml) {
        try {
            StreamSource source = new StreamSource(new StringReader(xml));
            JAXBElement root = unmarshaller.unmarshal((Source)source, TDefinitions.class);
            return (TDefinitions)root.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to marshal", e);
        }
    }

    static {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TDefinitions.class});
            marshaller = context.createMarshaller();
            unmarshaller = context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to initialize the JAXBContext", e);
        }
    }
}

